/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morebows.item;

import java.util.List;
import net.mcreator.morebows.MorebowsModElements;
import net.mcreator.morebows.itemgroup.MoreBowsItemGroup;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

@MorebowsModElements.ModElement.Tag
public class BowUpgradeItem
extends MorebowsModElements.ModElement {
    @ObjectHolder(value="morebows:bow_upgrade")
    public static final Item block = null;

    public BowUpgradeItem(MorebowsModElements instance) {
        super(instance, 6);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new BaseUpgrade(1));
        this.elements.items.add(() -> new BaseUpgrade(2));
        this.elements.items.add(() -> new BaseUpgrade(3));
        this.elements.items.add(() -> new DamageUpgrade(1));
        this.elements.items.add(() -> new DamageUpgrade(2));
        this.elements.items.add(() -> new DamageUpgrade(3));
        this.elements.items.add(() -> new DrawSpeedUpgrade(1));
        this.elements.items.add(() -> new DrawSpeedUpgrade(2));
        this.elements.items.add(() -> new DrawSpeedUpgrade(3));
        this.elements.items.add(() -> new ArrowSpeedUpgrade(1));
        this.elements.items.add(() -> new ArrowSpeedUpgrade(2));
        this.elements.items.add(() -> new ArrowSpeedUpgrade(3));
        this.elements.items.add(() -> new AccuracyUpgrade(1));
        this.elements.items.add(() -> new AccuracyUpgrade(2));
        this.elements.items.add(() -> new AccuracyUpgrade(3));
        this.elements.items.add(() -> new PiercingUpgrade(1));
        this.elements.items.add(() -> new PiercingUpgrade(2));
        this.elements.items.add(() -> new PiercingUpgrade(3));
        this.elements.items.add(() -> new AntigravityUpgrade(1));
        this.elements.items.add(() -> new AntigravityUpgrade(2));
        this.elements.items.add(() -> new AntigravityUpgrade(3));
        this.elements.items.add(() -> new VenomUpgrade(1));
        this.elements.items.add(() -> new VenomUpgrade(2));
        this.elements.items.add(() -> new VenomUpgrade(3));
        this.elements.items.add(() -> new DebilitateUpgrade(1));
        this.elements.items.add(() -> new DebilitateUpgrade(2));
        this.elements.items.add(() -> new DebilitateUpgrade(3));
        this.elements.items.add(() -> new MultishotUpgrade(1));
        this.elements.items.add(() -> new MultishotUpgrade(2));
        this.elements.items.add(() -> new MultishotUpgrade(3));
        this.elements.items.add(() -> new ExplosiveUpgrade(1));
        this.elements.items.add(() -> new ExplosiveUpgrade(2));
        this.elements.items.add(() -> new ExplosiveUpgrade(3));
    }

    public static String stringTier(int num) {
        switch (num) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
        }
        return "";
    }

    public static ItemCustom getUpgrade(String modifer, int tier) {
        switch (modifer) {
            case "base_damage": {
                return new DamageUpgrade(tier);
            }
            case "draw_speed": {
                return new DrawSpeedUpgrade(tier);
            }
            case "arrow_speed": {
                return new ArrowSpeedUpgrade(tier);
            }
            case "inaccuracy": {
                return new AccuracyUpgrade(tier);
            }
            case "piercing": {
                return new PiercingUpgrade(tier);
            }
            case "antigravity": {
                return new AntigravityUpgrade(tier);
            }
            case "venom": {
                return new VenomUpgrade(tier);
            }
            case "debilitate": {
                return new DebilitateUpgrade(tier);
            }
            case "multishot": {
                return new MultishotUpgrade(tier);
            }
            case "explosive": {
                return new ExplosiveUpgrade(tier);
            }
        }
        return null;
    }

    public static class ExplosiveUpgrade
    extends ItemCustom {
        public ExplosiveUpgrade(int tier) {
            super(tier);
            this.type = "Explosive";
            this.modifier = "explosive";
            this.op = 0;
            this.amount = 2.0f;
            this.upgradeID = 10;
            this.setRegName();
            this.info = "+2 blast power";
        }
    }

    public static class MultishotUpgrade
    extends ItemCustom {
        public MultishotUpgrade(int tier) {
            super(tier);
            this.type = "Multi-Shot";
            this.modifier = "multishot";
            this.op = 0;
            this.amount = 1.0f;
            this.upgradeID = 9;
            this.setRegName();
            this.info = "+1 arrow";
        }
    }

    public static class DebilitateUpgrade
    extends ItemCustom {
        public DebilitateUpgrade(int tier) {
            super(tier);
            this.type = "Debilitation";
            this.modifier = "debilitate";
            this.op = 0;
            this.amount = 1.0f;
            this.upgradeID = 8;
            this.setRegName();
            this.info = "+I slowness and weakness";
        }
    }

    public static class VenomUpgrade
    extends ItemCustom {
        public VenomUpgrade(int tier) {
            super(tier);
            this.type = "Venom";
            this.modifier = "venom";
            this.op = 0;
            this.amount = 1.0f;
            this.upgradeID = 7;
            this.setRegName();
            this.info = "+I poison and wither";
        }
    }

    public static class AntigravityUpgrade
    extends ItemCustom {
        public AntigravityUpgrade(int tier) {
            super(tier);
            this.type = "Anti-gravity";
            this.modifier = "antigravity";
            this.op = 0;
            this.amount = 2.0f;
            this.upgradeID = 6;
            this.setRegName();
            this.info = "+50% gravitional resistance";
        }
    }

    public static class PiercingUpgrade
    extends ItemCustom {
        public PiercingUpgrade(int tier) {
            super(tier);
            this.type = "Piercing";
            this.modifier = "piercing";
            this.op = 0;
            this.amount = 1.0f;
            this.upgradeID = 5;
            this.setRegName();
            this.info = "+1 mob";
        }
    }

    public static class AccuracyUpgrade
    extends ItemCustom {
        public AccuracyUpgrade(int tier) {
            super(tier);
            this.type = "Accuracy";
            this.modifier = "inaccuracy";
            this.op = 0;
            this.amount = -0.3f;
            this.upgradeID = 4;
            this.setRegName();
            this.info = "+30% accuracy";
        }
    }

    public static class ArrowSpeedUpgrade
    extends ItemCustom {
        public ArrowSpeedUpgrade(int tier) {
            super(tier);
            this.type = "Arrow Speed";
            this.modifier = "arrow_speed";
            this.op = 0;
            this.amount = 0.25f;
            this.upgradeID = 3;
            this.setRegName();
            this.info = "+25% arrow speed";
        }
    }

    public static class DrawSpeedUpgrade
    extends ItemCustom {
        public DrawSpeedUpgrade(int tier) {
            super(tier);
            this.type = "Draw Speed";
            this.modifier = "draw_speed";
            this.op = 0;
            this.amount = -5.0f;
            this.upgradeID = 2;
            this.setRegName();
            this.info = "+25% draw speed";
        }
    }

    public static class DamageUpgrade
    extends ItemCustom {
        public DamageUpgrade(int tier) {
            super(tier);
            this.type = "Damage";
            this.modifier = "base_damage";
            this.op = 0;
            this.amount = 1.0f;
            this.upgradeID = 1;
            this.setRegName();
            this.info = "+1 damage";
        }
    }

    public static class BaseUpgrade
    extends ItemCustom {
        public BaseUpgrade(int tier) {
            super(tier);
            this.type = "Base";
            this.modifier = "none";
            this.op = 0;
            this.amount = 0.0f;
            this.upgradeID = 0;
            this.setRegName();
            this.info = "Crafting ingredient for other bow upgrades";
        }
    }

    public static class ItemCustom
    extends Item {
        String type;
        int tier;
        int op;
        float amount;
        String modifier;
        int upgradeID;
        static int maxTier = 3;
        static String colorCode = "\u00a77";
        String info = "";

        public ItemCustom(int tier) {
            super(new Item.Properties().func_200916_a(MoreBowsItemGroup.tab).func_200917_a(1));
            this.tier = tier;
        }

        public void setRegName() {
            String id = String.valueOf(this.upgradeID) + String.valueOf(this.tier);
            if (this.upgradeID < 10) {
                id = "0" + id;
            }
            this.setRegistryName("bow_upgrade_" + id);
        }

        public void func_77624_a(ItemStack itemstack, World world, List<ITextComponent> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add((ITextComponent)new StringTextComponent(colorCode + this.info));
        }

        public String toString() {
            return this.type + " " + BowUpgradeItem.stringTier(this.tier);
        }

        public int func_77619_b() {
            return 0;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 0;
        }

        public float func_150893_a(ItemStack par1ItemStack, BlockState par2Block) {
            return 1.0f;
        }

        public ITextComponent func_200295_i(ItemStack stack) {
            String displayName = this.type + " Upgrade " + BowUpgradeItem.stringTier(this.tier);
            return new StringTextComponent(displayName);
        }

        public ITextComponent func_200296_o() {
            return this.func_200295_i(ItemStack.field_190927_a);
        }

        public int getTier() {
            return this.tier;
        }
    }
}

