/*
 * Decompiled with CFR 0.152.
 */
package com.deimoshexxus.netherhexedkingdommod.util.handlers;

import com.deimoshexxus.netherhexedkingdommod.Main;
import com.deimoshexxus.netherhexedkingdommod.init.ModBlocks;
import com.deimoshexxus.netherhexedkingdommod.init.ModEntities;
import com.deimoshexxus.netherhexedkingdommod.init.ModItems;
import com.deimoshexxus.netherhexedkingdommod.util.handlers.ConfigHandler;
import com.deimoshexxus.netherhexedkingdommod.util.handlers.RenderHandler;
import com.deimoshexxus.netherhexedkingdommod.util.handlers.SoundsHandler;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenMagmaCubeNest;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenNetherDamnedPrison;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenNetherGreedMines;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenNetherIronClad;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenNetherLostOutpost;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenNetherTowerOfRedSun;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenNetherWrathTower;
import com.deimoshexxus.netherhexedkingdommod.world.generators.WorldGenNetherWretchedLookout;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        RenderHandler.registerEntityRenders();
        for (Item item : ModItems.ITEMS) {
            Main.proxy.registerItemRenderer(item, 0, "inventory");
        }
        for (Block block : ModBlocks.BLOCKS) {
            Main.proxy.registerItemRenderer(Item.func_150898_a((Block)block), 0, "inventory");
        }
    }

    public static void preInitRegistries() {
        if (ConfigHandler.MAGMA_CUBE_NEST) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenMagmaCubeNest(), (int)5);
        }
        if (ConfigHandler.NETHER_DAMNED_PRISON) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherDamnedPrison(), (int)8);
        }
        if (ConfigHandler.NETHER_GREED_MINES) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherGreedMines(), (int)8);
        }
        if (ConfigHandler.NETHER_LOST_OUTPOST) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherLostOutpost(), (int)9);
        }
        if (ConfigHandler.NETHER_WRATH_TOWER) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherWrathTower(), (int)5);
        }
        if (ConfigHandler.NETHER_WRETCHED_LOOKOUT) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherWretchedLookout(), (int)7);
        }
        if (ConfigHandler.NETHER_IRON_CLAD) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherIronClad(), (int)5);
        }
        if (ConfigHandler.NETHER_TOWER_OF_RED_SUN) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherTowerOfRedSun(), (int)5);
        }
        System.out.println("Structures Added");
        ModEntities.registerEntities();
        SoundsHandler.registerSounds();
    }

    public static void initRegistries() {
    }

    public static void postInitRegistries() {
    }
}

