/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static enh makeModelCube(String spriteName, int tintIndex) {
        elv sprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static enh makeModelCube(elv sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        fz[] facings = fz.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fz facing = facings[i];
            ArrayList<ect> quads = new ArrayList<ect>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        edd itemOverrideList = edd.a;
        enq bakedModel = new enq(generalQuads, faceQuads, true, true, true, sprite, edf.a, itemOverrideList);
        return bakedModel;
    }

    public static enh joinModelsCube(enh modelBase, enh modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        fz[] facings = fz.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fz facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.d();
        elv sprite = modelBase.e();
        edf transforms = modelBase.f();
        edd itemOverrideList = modelBase.g();
        enq bakedModel = new enq(generalQuads, faceQuads, ao, builtIn, true, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static ect makeBakedQuad(fz facing, elv sprite, int tintIndex) {
        g posFrom = new g(0.0f, 0.0f, 0.0f);
        g posTo = new g(16.0f, 16.0f, 16.0f);
        ecx uv = new ecx(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        ecv face = new ecv(facing, tintIndex, "#" + facing.a(), uv);
        eni modelRotation = eni.a;
        ecw partRotation = null;
        boolean shade = true;
        uh modelLoc = sprite.l();
        eda faceBakery = new eda();
        ect quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (eno)modelRotation, partRotation, shade, modelLoc);
        return quad;
    }

    public static enh makeModel(String modelName, String spriteOldName, String spriteNewName) {
        elu textureMap = Config.getTextureMap();
        elv spriteOld = textureMap.getUploadedSprite(spriteOldName);
        elv spriteNew = textureMap.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static enh makeModel(String modelName, elv spriteOld, elv spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        enm modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        enn mrl = new enn(modelName, "");
        enh model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        enh modelNew = ModelUtils.duplicateModel(model);
        fz[] faces = fz.n;
        for (int i = 0; i < faces.length; ++i) {
            fz face = faces[i];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<ect> quads, elv spriteOld, elv spriteNew) {
        ArrayList<ect> quadsNew = new ArrayList<ect>();
        for (ect quad : quads) {
            if (quad.getSprite() == spriteOld) {
                quad = new BakedQuadRetextured(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(g pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static deg getOffsetBoundingBox(deg aabb, cfi.b offsetType, fu pos) {
        int x = pos.u();
        int z = pos.w();
        long k2 = (long)(x * 3129871) ^ (long)z * 116129781L;
        k2 = k2 * k2 * 42317861L + k2 * 11L;
        double dx = ((double)((float)(k2 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k2 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == cfi.b.c) {
            dy = ((double)((float)(k2 >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

