/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(cfj blockStateIn, bpg blockReaderIn, fu blockPosIn, fz facingIn, RenderEnv renderEnv) {
        fu posNeighbour = blockPosIn.a(facingIn);
        cfj stateNeighbour = blockReaderIn.d_(posNeighbour);
        if (stateNeighbour.isCacheOpaqueCube()) {
            return false;
        }
        if (blockStateIn.a(stateNeighbour, facingIn)) {
            return false;
        }
        if (stateNeighbour.l()) {
            return BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, stateNeighbour, posNeighbour);
        }
        return true;
    }

    public static boolean shouldSideBeRenderedCached(cfj blockStateIn, bpg blockReaderIn, fu blockPosIn, fz facingIn, RenderEnv renderEnv, cfj stateNeighbourIn, fu posNeighbourIn) {
        long key = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap map = renderEnv.getRenderSideMap();
        byte b0 = map.getAndMoveToFirst(key);
        if (b0 != 0) {
            return b0 > 0;
        }
        dfg voxelshape = blockStateIn.a(blockReaderIn, blockPosIn, facingIn);
        dfg voxelshape1 = stateNeighbourIn.a(blockReaderIn, posNeighbourIn, facingIn.f());
        boolean flag = dfd.c((dfg)voxelshape, (dfg)voxelshape1, (deq)deq.e);
        if (map.size() > 400) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst(key, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(bvr block) {
        return gl.aj.a((Object)block);
    }

    public static bvr getBlock(uh loc) {
        if (!gl.aj.c(loc)) {
            return null;
        }
        return (bvr)gl.aj.a(loc);
    }

    public static int getMetadata(cfj blockState) {
        bvr block = blockState.b();
        cfk stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        int metadata = validStates.indexOf(blockState);
        return metadata;
    }

    public static int getMetadataCount(bvr block) {
        cfk stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        return validStates.size();
    }

    public static cfj getBlockState(bvr block, int metadata) {
        cfk stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        if (metadata < 0 || metadata >= validStates.size()) {
            return null;
        }
        cfj blockState = (cfj)validStates.get(metadata);
        return blockState;
    }

    public static List<cfj> getBlockStates(bvr block) {
        cfk stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        return validStates;
    }

    public static boolean isFullCube(cfj stateIn, bpg blockReaderIn, fu posIn) {
        return stateIn.isCacheOpaqueCollisionShape();
    }

    public static Collection<cgl> getProperties(cfj blockState) {
        return blockState.r();
    }

    public static final class RenderSideCacheKey {
        private cfj blockState1;
        private cfj blockState2;
        private fz facing;
        private int hashCode;

        private RenderSideCacheKey(cfj blockState1In, cfj blockState2In, fz facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(cfj blockState1In, cfj blockState2In, fz facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == block$rendersidecachekey.blockState1 && this.blockState2 == block$rendersidecachekey.blockState2 && this.facing == block$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

