/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.fml;

import com.google.common.collect.Sets;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class OptiForgeTransformer<T>
implements ITransformer<ClassNode> {
    protected ITransformer<T> wrappedTransformer;
    protected ITransformer.Target target;

    public OptiForgeTransformer(ITransformer<T> wrappedTransformer, ITransformer.Target target) {
        this.wrappedTransformer = wrappedTransformer;
        this.target = target;
    }

    @Nonnull
    public ClassNode transform(@Nonnull ClassNode input, @Nonnull ITransformerVotingContext context) {
        ArrayList<Object> elements = new ArrayList<Object>();
        switch (this.target.getTargetType()) {
            case CLASS: {
                input = (ClassNode)this.wrappedTransformer.transform((Object)input, context);
                break;
            }
            case METHOD: {
                for (MethodNode mn : input.methods) {
                    if (mn.name.equals(this.target.getElementName()) && mn.desc.equals(this.target.getElementDescriptor())) {
                        mn = (MethodNode)this.wrappedTransformer.transform((Object)mn, context);
                    }
                    elements.add(mn);
                }
                input.methods = elements;
                break;
            }
            case FIELD: {
                for (FieldNode fn : input.fields) {
                    if (fn.name.equals(this.target.getElementName())) {
                        fn = (FieldNode)this.wrappedTransformer.transform((Object)fn, context);
                    }
                    elements.add(fn);
                }
                input.fields = elements;
            }
        }
        return input;
    }

    @Nonnull
    public TransformerVoteResult castVote(@Nonnull ITransformerVotingContext context) {
        return this.wrappedTransformer.castVote(context);
    }

    @Nonnull
    public Set<ITransformer.Target> targets() {
        return Sets.newHashSet((Object[])new ITransformer.Target[]{ITransformer.Target.targetClass((String)this.target.getClassName())});
    }

    public String[] labels() {
        return this.wrappedTransformer.labels();
    }
}

