/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.util.Annotations;

public class ASMUtils {
    public static int findLocalVariableIndex(MethodNode mn, String desc, int ordinal) {
        ArrayList localVariables = Lists.newArrayList((Iterable)mn.localVariables);
        localVariables.sort(Comparator.comparingInt(o -> o.index));
        for (LocalVariableNode lvn : localVariables) {
            if (!lvn.desc.equals(desc)) continue;
            if (ordinal == 0) {
                return lvn.index;
            }
            --ordinal;
        }
        return -1;
    }

    public static void insertLocalVariable(MethodNode mn, LocalVariableNode lvn) {
        int shift = lvn.desc.equals("J") || lvn.desc.equals("D") ? 2 : 1;
        for (LocalVariableNode node : mn.localVariables) {
            if (node.index < lvn.index) continue;
            node.index += shift;
        }
        for (AbstractInsnNode ain : mn.instructions.toArray()) {
            if (ain.getOpcode() >= 21 && ain.getOpcode() <= 25 || ain.getOpcode() >= 54 && ain.getOpcode() <= 58) {
                VarInsnNode vin = (VarInsnNode)ain;
                if (vin.var < lvn.index) continue;
                vin.var += shift;
                continue;
            }
            if (ain.getOpcode() != 132) continue;
            IincInsnNode iin = (IincInsnNode)ain;
            if (iin.var < lvn.index) continue;
            iin.var += shift;
        }
        mn.localVariables.add(lvn);
    }

    public static boolean isMixinMethod(MethodNode mn, String mixinClassName) {
        return mixinClassName.equals(Annotations.getValue((AnnotationNode)Annotations.getVisible((MethodNode)mn, MixinMerged.class), (String)"mixin"));
    }
}

