/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.passivepets.entity;

import net.mcreator.passivepets.PassivePetsModElements;
import net.mcreator.passivepets.item.BananaItem;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@PassivePetsModElements.ModElement.Tag
public class WildMonkeyEntity
extends PassivePetsModElements.ModElement {
    public static EntityType entity = null;

    public WildMonkeyEntity(PassivePetsModElements instance) {
        super(instance, 42);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.4f, 1.0f).func_206830_a("wild_monkey").setRegistryName("wild_monkey");
        this.elements.entities.add(() -> entity);
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            boolean biomeCriteria = false;
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("jungle"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("jungle_hills"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("jungle_edge"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("modified_jungle"))) {
                biomeCriteria = true;
            }
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("modified_jungle_edge"))) {
                biomeCriteria = true;
            }
            if (!biomeCriteria) continue;
            biome.func_76747_a(EntityClassification.AMBIENT).add(new Biome.SpawnListEntry(entity, 20, 5, 15));
        }
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(CustomEntity.class, renderManager -> new MobRenderer(renderManager, new Modelmonkey(), 0.5f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("passive_pets:textures/monkey.png");
            }
        });
    }

    public static class Modelmonkey
    extends EntityModel {
        private final RendererModel head;
        private final RendererModel body;
        private final RendererModel rleg;
        private final RendererModel lleg;
        private final RendererModel rarm;
        private final RendererModel larm;

        public Modelmonkey() {
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            this.head = new RendererModel((Model)this);
            this.head.func_78793_a(0.0f, 11.0f, -2.5f);
            this.head.field_78804_l.add(new ModelBox(this.head, 0, 0, -3.0f, -3.4428f, -1.5113f, 5, 4, 3, 0.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 13, 0, -2.0f, -1.4428f, -2.5113f, 3, 2, 1, 0.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 18, 13, -4.0f, -3.4428f, -1.0113f, 1, 2, 1, 0.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 8, 16, 2.0f, -3.4428f, -1.0113f, 1, 2, 1, 0.0f, false));
            this.body = new RendererModel((Model)this);
            this.body.func_78793_a(0.0f, 15.0f, -1.0f);
            this.setRotationAngle(this.body, 0.3491f, 0.0f, 0.0f);
            this.body.field_78804_l.add(new ModelBox(this.body, 0, 7, -3.0f, -4.0f, -1.0f, 5, 7, 2, 0.0f, false));
            this.rleg = new RendererModel((Model)this);
            this.rleg.func_78793_a(-2.0f, 18.0f, -0.4f);
            this.rleg.field_78804_l.add(new ModelBox(this.rleg, 18, 20, -1.0f, 0.0f, -0.6f, 2, 6, 2, 0.0f, false));
            this.lleg = new RendererModel((Model)this);
            this.lleg.func_78793_a(1.0f, 18.0f, -0.4f);
            this.lleg.field_78804_l.add(new ModelBox(this.lleg, 0, 16, -1.0f, 0.0f, -0.6f, 2, 6, 2, 0.0f, false));
            this.rarm = new RendererModel((Model)this);
            this.rarm.func_78793_a(-4.0f, 11.0f, -2.4f);
            this.rarm.field_78804_l.add(new ModelBox(this.rarm, 14, 5, -1.0f, 0.0f, -1.0f, 2, 6, 2, 0.0f, false));
            this.larm = new RendererModel((Model)this);
            this.larm.func_78793_a(3.0f, 11.0f, -2.4f);
            this.larm.field_78804_l.add(new ModelBox(this.larm, 12, 14, -1.0f, 0.0f, -1.0f, 2, 6, 2, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.head.func_78785_a(f5);
            this.body.func_78785_a(f5);
            this.rleg.func_78785_a(f5);
            this.lleg.func_78785_a(f5);
            this.rarm.func_78785_a(f5);
            this.larm.func_78785_a(f5);
        }

        public void setRotationAngle(RendererModel modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_212844_a_(Entity e, float f, float f1, float f2, float f3, float f4, float f5) {
            super.func_212844_a_(e, f, f1, f2, f3, f4, f5);
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.lleg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.larm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.rleg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.rarm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
        }
    }

    public static class CustomEntity
    extends CreatureEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
            this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)BananaItem.block, 1));
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        }
    }
}

