/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.item;

import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class PaxelItem
extends ToolItem
implements IEnableable {
    private static final Map<Block, BlockState> PATH_STUFF = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()));

    public PaxelItem(IItemTier tier, Function<Item.Properties, Item.Properties> properties) {
        super(4.0f, -3.2f, tier, new HashSet(), properties.apply(new Item.Properties().func_200915_b((int)((double)tier.func_200926_a() * 1.5)).addToolType(ToolType.PICKAXE, tier.func_200925_d()).addToolType(ToolType.SHOVEL, tier.func_200925_d()).addToolType(ToolType.AXE, tier.func_200925_d())));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled()) {
            super.func_150895_a(group, items);
        }
    }

    public boolean func_150897_b(BlockState state) {
        Block block = state.func_177230_c();
        int i = this.func_200891_e().func_200925_d();
        if (state.getHarvestTool() == ToolType.PICKAXE) {
            return i >= state.getHarvestLevel();
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g || block == Blocks.field_150433_aE || block == Blocks.field_196604_cC;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e && material != Material.field_151575_d && material != Material.field_237214_y_ && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_215713_z ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState state;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (context.func_196000_l() != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).isAir((IBlockReader)world, pos.func_177984_a()) && (state = PATH_STUFF.get(world.func_180495_p(pos).func_177230_c())) != null) {
            PlayerEntity player = context.func_195999_j();
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, state, 11);
                if (player != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean isEnabled() {
        return (Boolean)ModConfigs.ENABLE_PAXELS.get();
    }
}

