/*
 * Decompiled with CFR 0.152.
 */
package io.github.coolmineman.plantinajar;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.mixin.api.IBucketItem;
import alexiil.mc.lib.attributes.fluid.render.FluidRenderFace;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import io.github.coolmineman.plantinajar.CoolFluidVolumeRenderer;
import io.github.coolmineman.plantinajar.JarBlockEntity;
import io.github.coolmineman.plantinajar.PlantInAJar;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2266;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2511;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class JarBlockEntityRenderer
extends class_827<JarBlockEntity> {
    private static final FluidVolume WATER_VOLUME = FluidKeys.WATER.withAmount(FluidAmount.BUCKET);
    private static final List<FluidRenderFace> RENDER_FACES;
    public static final CoolTreeEnum[][][] tree;
    public static final CoolTreeEnum[][][] chorus;
    public static final CoolTreeEnum[][][] RED_MUSHROOM;
    public static final CoolTreeEnum[][][] BROWN_MUSHROOM;

    public static float getScaleFactor() {
        return 1.0f / (float)(PlantInAJar.CONFIG.getGrowthTime() * 20);
    }

    public static CoolTreeEnum[][][] doTreeEpic(String[][] treePattern) {
        CoolTreeEnum[][][] tree1 = new CoolTreeEnum[treePattern[0].length][treePattern.length][treePattern[0][0].length()];
        for (int i = 0; i < treePattern.length; ++i) {
            for (int j = 0; j < treePattern[i].length; ++j) {
                char[] e = treePattern[i][j].toCharArray();
                for (int k = 0; k < e.length; ++k) {
                    tree1[j][i][k] = e[k] == 'w' ? CoolTreeEnum.WOOD : (e[k] == 'l' ? CoolTreeEnum.LEAVES : CoolTreeEnum.AIR);
                }
            }
        }
        return tree1;
    }

    public JarBlockEntityRenderer(class_824 dispatcher) {
        super(dispatcher);
    }

    public static void renderTree(class_2680 wood, class_2680 leaves, CoolTreeEnum[][][] epictree, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        int offset = (epictree.length - 1) / 2;
        matrices.method_22904((double)(-offset), 0.0, (double)(-offset));
        for (int i = 0; i < epictree.length; ++i) {
            for (int j = 0; j < epictree[i].length; ++j) {
                for (int k = 0; k < epictree[i][j].length; ++k) {
                    if (epictree[i][j][k] == CoolTreeEnum.WOOD) {
                        matrices.method_22904((double)i, (double)j, (double)k);
                        class_310.method_1551().method_1541().method_3353(wood, matrices, vertexConsumers, light, overlay);
                        matrices.method_22904((double)(-i), (double)(-j), (double)(-k));
                        continue;
                    }
                    if (epictree[i][j][k] != CoolTreeEnum.LEAVES) continue;
                    matrices.method_22904((double)i, (double)j, (double)k);
                    class_310.method_1551().method_1541().method_3353(leaves, matrices, vertexConsumers, light, overlay);
                    matrices.method_22904((double)(-i), (double)(-j), (double)(-k));
                }
            }
        }
        matrices.method_22904((double)offset, 0.0, (double)offset);
    }

    public static void scaleCenterAligned(class_4587 matrices, float x, float y, float z) {
        matrices.method_22904((double)(1.0f - x) * 0.5, (double)(1.0f - x) * 0.5, (double)(1.0f - z) * 0.5);
        matrices.method_22905(x, y, z);
    }

    public static void scaleBottomAligned(class_4587 matrices, float scalefactor) {
        matrices.method_22904(0.0, (double)scalefactor * 0.5, 0.0);
        JarBlockEntityRenderer.scaleCenterAligned(matrices, scalefactor, scalefactor, scalefactor);
    }

    public void render(JarBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        IBucketItem item;
        matrices.method_22903();
        class_2680 base = entity.getBase();
        matrices.method_22904(0.0, 0.03125, 0.0);
        if (base.method_27852(class_2246.field_10306)) {
            matrices.method_22904(0.0, 0.03125, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.999f, 1.0f, 0.999f);
            matrices.method_22904(0.0, -0.5, -0.25);
            JarBlockEntityRenderer.scaleBottomAligned(matrices, 0.5f);
            class_310.method_1551().method_1541().method_3353(base, matrices, vertexConsumers, light, overlay);
        } else if (base.method_27852(class_2246.field_10382)) {
            matrices.method_22904(0.0, -0.03125, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.999f, 0.999f, 0.999f);
            CoolFluidVolumeRenderer.INSTANCE.render(WATER_VOLUME, RENDER_FACES, vertexConsumers, matrices);
        } else if (entity.getBaseItemStack().method_7909() instanceof IBucketItem) {
            matrices.method_22904(0.0, -0.03125, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.999f, 0.999f, 0.999f);
            item = (IBucketItem)entity.getBaseItemStack().method_7909();
            if (!item.libblockattributes__getFluid(entity.getBaseItemStack()).equals((Object)FluidKeys.EMPTY)) {
                ArrayList a = new ArrayList();
                FluidRenderFace.appendCuboid((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)item.libblockattributes__getFluidVolumeAmount().asInexactDouble(), (double)1.0, (double)1.0, EnumSet.allOf(class_2350.class), a);
                CoolFluidVolumeRenderer.INSTANCE.render(item.libblockattributes__getFluid(entity.getBaseItemStack()).withAmount(FluidAmount.BUCKET), a, vertexConsumers, matrices);
            }
        } else {
            matrices.method_22904((double)5.0E-4f, 0.0, (double)5.0E-4f);
            matrices.method_22905(0.999f, 0.03125f, 0.999f);
            class_310.method_1551().method_1541().method_3353(base, matrices, vertexConsumers, light, overlay);
        }
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0625, 0.0);
        JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.999f, 0.999f, 0.999f);
        if (JarBlockEntity.isTree(entity.getPlant())) {
            matrices.method_22904(0.0, -0.5, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.14285715f, 0.14285715f, 0.14285715f);
            float scalefactor = ((float)entity.getTickyes() + tickDelta) * JarBlockEntityRenderer.getScaleFactor();
            if (scalefactor > 1.0f) {
                scalefactor = 1.0f;
            }
            JarBlockEntityRenderer.scaleBottomAligned(matrices, scalefactor);
            JarBlockEntityRenderer.renderTree(JarBlockEntity.getTreeBlockWood(entity.getPlant()), JarBlockEntity.getTreeBlockLeaf(entity.getPlant()), tree, matrices, vertexConsumers, light, overlay);
        } else if (entity.getPlant().method_27852(class_2246.field_10302)) {
            matrices.method_22904(0.0, -0.5, 0.25);
            JarBlockEntityRenderer.scaleBottomAligned(matrices, 0.5f);
            class_310.method_1551().method_1541().method_3353(entity.getPlant(), matrices, vertexConsumers, light, overlay);
        } else if (entity.getPlant().method_27852(class_2246.field_10528)) {
            matrices.method_22904(0.0, -0.5, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.05882353f, 0.05882353f, 0.05882353f);
            float scalefactor = ((float)entity.getTickyes() + tickDelta) * JarBlockEntityRenderer.getScaleFactor();
            if (scalefactor > 1.0f) {
                scalefactor = 1.0f;
            }
            JarBlockEntityRenderer.scaleBottomAligned(matrices, scalefactor);
            JarBlockEntityRenderer.renderTree((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_10021.method_9564().method_11657((class_2769)class_2429.field_11330, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11327, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11332, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11331, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11328, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2429.field_11335, (Comparable)Boolean.valueOf(true)), class_2246.field_10528.method_9564(), chorus, matrices, vertexConsumers, light, overlay);
        } else if (entity.getPlant().method_27852(class_2246.field_10559)) {
            matrices.method_22904(0.0, -0.5, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.14285715f, 0.14285715f, 0.14285715f);
            float scalefactor = ((float)entity.getTickyes() + tickDelta) * JarBlockEntityRenderer.getScaleFactor();
            if (scalefactor > 1.0f) {
                scalefactor = 1.0f;
            }
            JarBlockEntityRenderer.scaleBottomAligned(matrices, scalefactor);
            JarBlockEntityRenderer.renderTree(class_2246.field_10556.method_9564(), class_2246.field_10240.method_9564(), RED_MUSHROOM, matrices, vertexConsumers, light, overlay);
        } else if (entity.getPlant().method_27852(class_2246.field_10251)) {
            matrices.method_22904(0.0, -0.5, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.14285715f, 0.14285715f, 0.14285715f);
            float scalefactor = ((float)entity.getTickyes() + tickDelta) * JarBlockEntityRenderer.getScaleFactor();
            if (scalefactor > 1.0f) {
                scalefactor = 1.0f;
            }
            JarBlockEntityRenderer.scaleBottomAligned(matrices, scalefactor);
            JarBlockEntityRenderer.renderTree(class_2246.field_10556.method_9564(), class_2246.field_10580.method_9564(), BROWN_MUSHROOM, matrices, vertexConsumers, light, overlay);
        } else if (entity.getPlant().method_26204() instanceof class_2511 || entity.getPlant().method_26204() instanceof class_2266 || entity.getPlant().method_26204() instanceof class_2211 || entity.getPlant().method_26204() instanceof class_2523) {
            matrices.method_22904(0.0, -0.5, 0.0);
            JarBlockEntityRenderer.scaleCenterAligned(matrices, 0.6666667f, 0.6666667f, 0.6666667f);
            float scalefactor = ((float)entity.getTickyes() + tickDelta) * JarBlockEntityRenderer.getScaleFactor();
            if (scalefactor > 1.0f) {
                scalefactor = 1.0f;
            }
            JarBlockEntityRenderer.scaleBottomAligned(matrices, scalefactor);
            class_310.method_1551().method_1541().method_3353(entity.getPlant(), matrices, vertexConsumers, light, overlay);
        } else if (entity.getPlant().method_27852(class_2246.field_10376) || entity.getPlant().method_27852(class_2246.field_9993) || entity.getPlant().method_27852(class_2246.field_10476)) {
            matrices.method_22904(0.0, -0.5, 0.0);
            float scalefactor = ((float)entity.getTickyes() + tickDelta) * JarBlockEntityRenderer.getScaleFactor();
            if (scalefactor > 1.0f) {
                scalefactor = 1.0f;
            }
            JarBlockEntityRenderer.scaleBottomAligned(matrices, scalefactor);
            class_310.method_1551().method_1541().method_3353(entity.getPlant(), matrices, vertexConsumers, light, overlay);
        } else if (entity.getPlant().method_27852(class_2246.field_10588)) {
            float scalefactor;
            matrices.method_22904(0.0, -0.5625, 0.0);
            if (entity.getBaseItemStack().method_7909() instanceof IBucketItem) {
                item = (IBucketItem)entity.getBaseItemStack().method_7909();
                matrices.method_22904(0.0, item.libblockattributes__getFluidVolumeAmount().asInexactDouble(), 0.0);
            }
            if ((scalefactor = ((float)entity.getTickyes() + tickDelta) * JarBlockEntityRenderer.getScaleFactor()) > 1.0f) {
                scalefactor = 1.0f;
            }
            JarBlockEntityRenderer.scaleBottomAligned(matrices, scalefactor);
            class_310.method_1551().method_1541().method_3353(entity.getPlant(), matrices, vertexConsumers, light, overlay);
        } else {
            class_310.method_1551().method_1541().method_3353(entity.getPlant(), matrices, vertexConsumers, light, overlay);
        }
        matrices.method_22909();
    }

    static {
        String[][] treePattern = new String[][]{{"     ", "     ", "  w  ", "     ", "     "}, {"     ", "     ", "  w  ", "     ", "     "}, {" lll ", "lllll", "llwll", "lllll", " lll "}, {" lll ", "lllll", "llwll", "lllll", " lll "}, {"     ", "  l  ", " lwl ", "  l  ", "     "}, {"     ", "  l  ", " lll ", "  l  ", "     "}};
        tree = JarBlockEntityRenderer.doTreeEpic(treePattern);
        String[][] chorusPattern = new String[][]{{"     ", "     ", "  w  ", "     ", "     "}, {"     ", "     ", "  w  ", "     ", "     "}, {"     ", "     ", "  w  ", "     ", "     "}, {"     ", "     ", "  w  ", "     ", "     "}, {"     ", "     ", "  w  ", "     ", "     "}, {"     ", "  w  ", "  w  ", "     ", "     "}, {"     ", "  w  ", "     ", "     ", "     "}, {"     ", " ww  ", "  w  ", "     ", "     "}, {"     ", " w   ", "  w  ", "     ", "     "}, {"     ", " w   ", "  ww ", "  w  ", "     "}, {"     ", "www  ", "   w ", "  w  ", "     "}, {"     ", "l w  ", "   w ", "  w  ", "     "}, {"  w  ", " ww  ", "   l ", "  w  ", "  w  "}, {"  l  ", " w   ", "     ", "     ", "  w  "}, {"     ", " w   ", "     ", "     ", "  l  "}, {"     ", " l   ", "     ", "     ", "     "}};
        chorus = JarBlockEntityRenderer.doTreeEpic(chorusPattern);
        String[][] mushroomPattern1 = new String[][]{{"     ", "     ", "  w  ", "     ", "     "}, {"     ", "     ", "  w  ", "     ", "     "}, {" lll ", "l   l", "l w l", "l   l", " lll "}, {" lll ", "l   l", "l w l", "l   l", " lll "}, {" lll ", "l   l", "l w l", "l   l", " lll "}, {"     ", " lll ", " lll ", " lll ", "     "}};
        RED_MUSHROOM = JarBlockEntityRenderer.doTreeEpic(mushroomPattern1);
        String[][] mushroomPattern2 = new String[][]{{"       ", "       ", "       ", "   w   ", "       ", "       ", "       "}, {"       ", "       ", "       ", "   w   ", "       ", "       ", "       "}, {"       ", "       ", "       ", "   w   ", "       ", "       ", "       "}, {"       ", "       ", "       ", "   w   ", "       ", "       ", "       "}, {"       ", "       ", "       ", "   w   ", "       ", "       ", "       "}, {" lllll ", "lllllll", "lllllll", "lllllll", "lllllll", "lllllll", " lllll "}};
        BROWN_MUSHROOM = JarBlockEntityRenderer.doTreeEpic(mushroomPattern2);
        ArrayList<FluidRenderFace> a = new ArrayList<FluidRenderFace>();
        FluidRenderFace.appendCuboid((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)1.0, EnumSet.allOf(class_2350.class), a);
        RENDER_FACES = a;
    }

    public static enum CoolTreeEnum {
        WOOD,
        LEAVES,
        AIR;

    }
}

