/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2;

import java.util.function.Supplier;
import net.kaneka.planttech2.items.BiomassContainerItem;
import net.kaneka.planttech2.items.PlantObtainerItem;
import net.kaneka.planttech2.items.upgradeable.MultitoolItem;
import net.kaneka.planttech2.items.upgradeable.RangedWeaponItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModFluids;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModRenderer;
import net.kaneka.planttech2.registries.ModScreens;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="planttech2", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PlantTechClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ModRenderer.registerEntityRenderer();
            ModScreens.registerGUI();
            for (Supplier<? extends Block> block : ModBlocks.SPECIAL_RENDER_BLOCKS) {
                RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)RenderType.func_228641_d_());
            }
            RenderTypeLookup.setRenderLayer((Block)ModBlocks.BIOMASSFLUIDBLOCK, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIOMASS, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIOMASS_FLOWING, (RenderType)RenderType.func_228645_f_());
            PlantTechClient.addAllItemModelsOverrides();
        });
    }

    private static void addAllItemModelsOverrides() {
        ItemModelsProperties.func_239418_a_((Item)ModItems.MULTITOOL, (ResourceLocation)new ResourceLocation("planttech2", "drilling"), (stack, world, entity) -> entity == null || !(stack.func_77973_b() instanceof MultitoolItem) ? 0.0f : (float)(entity.field_70173_aa % 4 + 1));
        ItemModelsProperties.func_239418_a_((Item)ModItems.PLANT_OBTAINER, (ResourceLocation)new ResourceLocation("planttech2", "filled"), (stack, world, entity) -> {
            if (!(stack.func_77973_b() instanceof PlantObtainerItem)) {
                return 0.0f;
            }
            return PlantObtainerItem.isFilled(PlantObtainerItem.initTags(stack)) ? 1.0f : 0.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)ModItems.PLANT_OBTAINER, (ResourceLocation)new ResourceLocation("planttech2", "filled"), (stack, world, entity) -> BiomassContainerItem.getFillLevelModel(stack));
        ItemModelsProperties.func_239418_a_((Item)ModItems.CYBERBOW, (ResourceLocation)new ResourceLocation("planttech2", "pull"), (stack, world, entity) -> entity == null || !(entity.func_184607_cu().func_77973_b() instanceof RangedWeaponItem) ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f);
        ItemModelsProperties.func_239418_a_((Item)ModItems.CYBERBOW, (ResourceLocation)new ResourceLocation("planttech2", "pulling"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }
}

