/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.machines;

import java.util.List;
import java.util.function.Supplier;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MachineBaseBlock
extends Block {
    private final Supplier<? extends TileEntity> teCreator;
    private final int tier;

    public MachineBaseBlock(Supplier<? extends TileEntity> teCreator, int tier) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 10.0f).func_226896_b_());
        this.teCreator = teCreator;
        this.tier = tier;
    }

    public MachineBaseBlock(Supplier<? extends TileEntity> teCreator) {
        this(teCreator, 0);
    }

    public IItemProvider getItemDropped(BlockState state, World worldIn, BlockPos pos, int fortune) {
        return this;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof EnergyTileEntity) {
            player.func_213829_a((INamedContainerProvider)((EnergyTileEntity)te));
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.teCreator.get();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            if (worldIn.func_175625_s(pos) instanceof EnergyInventoryTileEntity) {
                EnergyInventoryTileEntity te = (EnergyInventoryTileEntity)worldIn.func_175625_s(pos);
                List<ItemStack> toSpawn = te.getInventoryContent();
                for (ItemStack stack : toSpawn) {
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
                }
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.tier").getString() + ": " + this.tier));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

