/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.machines;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.kaneka.planttech2.blocks.machines.CableBlock;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.cable.TestCableTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;

public class TestCableBlock
extends Block {
    public static final IntegerProperty NORTH = IntegerProperty.func_177719_a((String)"north", (int)0, (int)3);
    public static final IntegerProperty EAST = IntegerProperty.func_177719_a((String)"east", (int)0, (int)3);
    public static final IntegerProperty SOUTH = IntegerProperty.func_177719_a((String)"south", (int)0, (int)3);
    public static final IntegerProperty WEST = IntegerProperty.func_177719_a((String)"west", (int)0, (int)3);
    public static final IntegerProperty UP = IntegerProperty.func_177719_a((String)"up", (int)0, (int)3);
    public static final IntegerProperty DOWN = IntegerProperty.func_177719_a((String)"down", (int)0, (int)3);
    public static final Map<Direction, IntegerProperty> DIRECTIONS = new HashMap<Direction, IntegerProperty>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.NORTH, NORTH);
            this.put(Direction.EAST, EAST);
            this.put(Direction.SOUTH, SOUTH);
            this.put(Direction.WEST, WEST);
            this.put(Direction.UP, UP);
            this.put(Direction.DOWN, DOWN);
        }
    };
    private static final VoxelShape POST = TestCableBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    private static final Map<Direction, VoxelShape> CONNECTION_VOXELS = new HashMap<Direction, VoxelShape>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.DOWN, Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0));
            this.put(Direction.UP, Block.func_208617_a((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
            this.put(Direction.NORTH, Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)2.0));
            this.put(Direction.SOUTH, Block.func_208617_a((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0, (double)16.0));
            this.put(Direction.WEST, Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0));
            this.put(Direction.EAST, Block.func_208617_a((double)14.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        }
    };
    private static final Map<Direction, VoxelShape> CABLE_VOXELS = new HashMap<Direction, VoxelShape>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.DOWN, Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0));
            this.put(Direction.UP, Block.func_208617_a((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
            this.put(Direction.NORTH, Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0));
            this.put(Direction.SOUTH, Block.func_208617_a((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0));
            this.put(Direction.WEST, Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0));
            this.put(Direction.EAST, Block.func_208617_a((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0));
        }
    };
    protected final VoxelShape[][][][][][] shapes = new VoxelShape[3][3][3][3][3][3];

    public TestCableBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(0.5f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Integer.valueOf(0))).func_206870_a((Property)EAST, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SOUTH, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WEST, (Comparable)Integer.valueOf(0))).func_206870_a((Property)UP, (Comparable)Integer.valueOf(0))).func_206870_a((Property)DOWN, (Comparable)Integer.valueOf(0)));
        this.initShapes();
    }

    private void initShapes() {
        for (int d = 0; d < 3; ++d) {
            for (int u = 0; u < 3; ++u) {
                for (int n = 0; n < 3; ++n) {
                    for (int s = 0; s < 3; ++s) {
                        for (int w = 0; w < 3; ++w) {
                            for (int e = 0; e < 3; ++e) {
                                this.shapes[d][u][n][s][w][e] = this.getCombinedShape(d, u, n, s, w, e);
                            }
                        }
                    }
                }
            }
        }
    }

    private VoxelShape getCombinedShape(int ... states) {
        VoxelShape shape = POST;
        if (states.length == 6) {
            for (int i = 0; i < 6; ++i) {
                int state = states[i];
                Direction direction = Direction.func_82600_a((int)i);
                if (state <= 0) continue;
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CABLE_VOXELS.get(direction));
                if (state <= 1) continue;
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CONNECTION_VOXELS.get(direction));
            }
        }
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[Math.min(2, (Integer)state.func_177229_b((Property)DOWN))][Math.min(2, (Integer)state.func_177229_b((Property)UP))][Math.min(2, (Integer)state.func_177229_b((Property)NORTH))][Math.min(2, (Integer)state.func_177229_b((Property)SOUTH))][Math.min(2, (Integer)state.func_177229_b((Property)WEST))][Math.min(2, (Integer)state.func_177229_b((Property)EAST))];
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (!worldIn.func_201670_d() && hand.equals((Object)Hand.MAIN_HAND) && player.func_184614_ca().func_77973_b().equals((Object)ModItems.WRENCH)) {
            Vector3d hitvec = ray.func_216347_e();
            hitvec = hitvec.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            for (Direction dir : Direction.values()) {
                TestCableTileEntity te;
                VoxelShape tempshape = CONNECTION_VOXELS.get(dir);
                if (!(tempshape.func_197762_b(Direction.Axis.X) <= hitvec.field_72450_a) || !(tempshape.func_197758_c(Direction.Axis.X) >= hitvec.field_72450_a) || !(tempshape.func_197762_b(Direction.Axis.Y) <= hitvec.field_72448_b) || !(tempshape.func_197758_c(Direction.Axis.Y) >= hitvec.field_72448_b) || !(tempshape.func_197762_b(Direction.Axis.Z) <= hitvec.field_72449_c) || !(tempshape.func_197758_c(Direction.Axis.Z) >= hitvec.field_72449_c) || (te = this.getTECable(worldIn, pos)) == null) continue;
                te.rotateConnection(dir);
                worldIn.func_180501_a(pos, this.getCurrentState(state, worldIn, pos), 3);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldstate, boolean bool) {
        TestCableTileEntity te;
        if (!world.func_201670_d() && state.func_177230_c() != oldstate.func_177230_c() && (te = this.getTECable(world, pos)) != null) {
            te.initCable();
            world.func_180501_a(pos, this.getCurrentState(state, world, pos), 3);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TestCableTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.func_201670_d() && state.func_177230_c() != newState.func_177230_c()) {
            this.modifyCable(worldIn, pos, TestCableTileEntity::func_145843_s);
            worldIn.func_175713_t(pos);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        if (!world.func_201670_d()) {
            this.checkConnections(world, pos);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = this.func_176223_P();
        for (Direction facing : Direction.values()) {
            BlockState stateDirection = world.func_180495_p(pos.func_177972_a(facing));
            TileEntity te = world.func_175625_s(pos.func_177972_a(facing));
            if (stateDirection.func_177230_c() instanceof CableBlock) {
                state.func_206870_a((Property)DIRECTIONS.get(facing), (Comparable)Integer.valueOf(1));
                continue;
            }
            if (te != null && te.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
                state.func_206870_a((Property)DIRECTIONS.get(facing), (Comparable)Integer.valueOf(2));
                continue;
            }
            state.func_206870_a((Property)DIRECTIONS.get(facing), (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.getCurrentState(state, (World)world, currentPos);
    }

    public BlockState getCurrentState(BlockState state, World world, BlockPos pos) {
        TestCableTileEntity cable = this.getTECable(world, pos);
        if (cable != null) {
            cable.checkConnections();
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)UP, (Comparable)Integer.valueOf(cable.getConnection(Direction.UP)))).func_206870_a((Property)DOWN, (Comparable)Integer.valueOf(cable.getConnection(Direction.DOWN)))).func_206870_a((Property)EAST, (Comparable)Integer.valueOf(cable.getConnection(Direction.EAST)))).func_206870_a((Property)WEST, (Comparable)Integer.valueOf(cable.getConnection(Direction.WEST)))).func_206870_a((Property)NORTH, (Comparable)Integer.valueOf(cable.getConnection(Direction.NORTH)))).func_206870_a((Property)SOUTH, (Comparable)Integer.valueOf(cable.getConnection(Direction.SOUTH)));
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    private TestCableTileEntity getTECable(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof TestCableTileEntity ? (TestCableTileEntity)tileentity : null;
    }

    private void checkConnections(World world, BlockPos pos) {
        this.modifyCable(world, pos, TestCableTileEntity::checkConnections);
    }

    private void modifyCable(World world, BlockPos pos, Consumer<TestCableTileEntity> modification) {
        TestCableTileEntity cable = this.getTECable(world, pos);
        if (cable != null) {
            modification.accept(cable);
        }
    }

    public static class ConnnectionState {
    }
}

