/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class DevListCommand {
    public static final Map<String, List<String>> AUTHORS = new ImmutableMap.Builder().put((Object)"Kaneka", (Object)ImmutableList.of((Object)"df361308-a4b8-469c-a3b6-63bb8b2ec7e3")).put((Object)"Poopoodice", (Object)ImmutableList.of((Object)"f0c9774d-e79f-4a58-b524-3f3d014e58ed", (Object)"b3fd2b3b-df09-4790-8187-650219671a69")).put((Object)"Setrion", (Object)ImmutableList.of((Object)"c5beef70-7f28-44c8-a1cc-91a1cc8836e6")).build();
    public static final Map<String, List<String>> ARTISTS = new ImmutableMap.Builder().put((Object)"VeyezX (Vex)", (Object)ImmutableList.of((Object)"8ea51d9d-ccc9-4ce4-a9fd-9e8b5d1ceaf3")).put((Object)"BeerCav", (Object)ImmutableList.of((Object)"bc58f1ec-9853-4dd0-a0bb-da38cfaf6fe6")).put((Object)"DinoSoup", (Object)ImmutableList.of((Object)"1dc30eef-5be5-4afa-9e1e-9a5c20df653f")).put((Object)"MoonlitLamps", (Object)ImmutableList.of()).put((Object)"andrew0030", (Object)ImmutableList.of((Object)"0b37421b-e74e-4852-bf57-23907d295ea1")).build();
    public static final Map<String, List<String>> SPECIAL_THANKS = new ImmutableMap.Builder().put((Object)"Sciwhiz12", (Object)ImmutableList.of()).build();

    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"devlist").executes(context -> {
            int online = 0;
            CommandSource src = (CommandSource)context.getSource();
            src.func_197030_a((ITextComponent)new StringTextComponent("---- Plant Tech 2 Developers ----").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GREEN, TextFormatting.BOLD, TextFormatting.UNDERLINE}), false);
            DevListCommand.printTitle(src, "Artists:");
            online += DevListCommand.printAllFromList(ARTISTS, src);
            DevListCommand.printTitle(src, "Authors:");
            online += DevListCommand.printAllFromList(AUTHORS, src);
            DevListCommand.printTitle(src, "Special Thanks:");
            return online += DevListCommand.printAllFromList(AUTHORS, src, true);
        });
    }

    private static void printTitle(CommandSource source, String message) {
        source.func_197030_a((ITextComponent)new StringTextComponent(message).func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.BOLD}), false);
    }

    private static int printAllFromList(Map<String, List<String>> map, CommandSource src) {
        return DevListCommand.printAllFromList(map, src, false);
    }

    private static int printAllFromList(Map<String, List<String>> map, CommandSource src, boolean contributionDone) {
        int online = 0;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            StringTextComponent name = new StringTextComponent(entry.getKey());
            if (DevListCommand.isOnline(src.func_197028_i(), entry.getValue())) {
                name.func_230529_a_((ITextComponent)new StringTextComponent(" (online)").func_240699_a_(TextFormatting.GREEN));
                ++online;
            }
            if (contributionDone) {
                name = new StringTextComponent("Thanks " + name + DevListCommand.getContribution(entry.getKey()));
            }
            src.func_197030_a((ITextComponent)name, false);
        }
        return online;
    }

    private static boolean isOnline(MinecraftServer server, List<String> uuidList) {
        return uuidList.stream().anyMatch(uuid -> server.func_184103_al().func_177451_a(UUID.fromString(uuid)) != null);
    }

    public static String getContribution(String username) {
        switch (username) {
            default: {
                return "";
            }
            case "Sciwhiz12": 
        }
        return "for greatly improving the code!";
    }
}

