/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.packets.CropConfigChangeMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CropListReloadListener
extends JsonReloadListener {
    public static final String FOLDER = "pt2_crops";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CropEntryConfigData.class, (Object)CropEntryConfigData.Serializer.INSTANCE).registerTypeAdapter(DropEntry.class, (Object)DropEntry.Serializer.INSTANCE).registerTypeAdapter(ParentPair.class, (Object)ParentPair.Serializer.INSTANCE).create();

    public CropListReloadListener() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> elementMap, IResourceManager resourceManager, IProfiler profiler) {
        PlantTechMain.LOGGER.debug("Loading crop configurations");
        HashMap<ResourceLocation, CropEntryConfigData> configs = new HashMap<ResourceLocation, CropEntryConfigData>();
        LinkedList<ResourceLocation> keys = new LinkedList<ResourceLocation>(elementMap.keySet());
        keys.sort((a, b) -> a.func_110624_b().equals("planttech2") ? -1 : a.compareTo(b));
        for (ResourceLocation key : keys) {
            try {
                JsonElement element = elementMap.get(key);
                if (!CraftingHelper.processConditions((JsonObject)JSONUtils.func_151210_l((JsonElement)element, (String)"top element"), (String)"conditions")) {
                    PlantTechMain.LOGGER.debug("Skipping loading crop configuration {} as it's conditions were not met", (Object)key);
                    continue;
                }
                configs.put(key, (CropEntryConfigData)GSON.fromJson(element, CropEntryConfigData.class));
            }
            catch (JsonSyntaxException | IllegalArgumentException ex) {
                PlantTechMain.LOGGER.error("Error while loading crop configuration {}", (Object)key, (Object)ex);
            }
        }
        PlantTechMain.getCropList().configureFromConfigData(configs.values());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                PlantTech2PacketHandler.sendTo(new CropConfigChangeMessage(configs), player);
            }
        }
    }

    public static JsonElement toJson(CropEntryConfigData data) {
        return GSON.toJsonTree((Object)data);
    }
}

