/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.capabilities.player;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kaneka.planttech2.entities.capabilities.player.IRadiationEffect;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.packets.SyncRadiationLevelMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class RadiationEffect
implements ICapabilitySerializable<CompoundNBT>,
IRadiationEffect {
    @CapabilityInject(value=IRadiationEffect.class)
    public static Capability<IRadiationEffect> RADIATION_CAPABILITY = null;
    private final LazyOptional<IRadiationEffect> lazyOptional = LazyOptional.of(RadiationEffect::new);
    private float level;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == RADIATION_CAPABILITY ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public static IRadiationEffect getCap(ServerPlayerEntity player) {
        IRadiationEffect cap = (IRadiationEffect)player.getCapability(RADIATION_CAPABILITY).orElseThrow(() -> new NullPointerException("getting capability"));
        PlantTech2PacketHandler.sendTo(new SyncRadiationLevelMessage(cap.getLevel()), player);
        return cap;
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)RADIATION_CAPABILITY.getStorage().writeNBT(RADIATION_CAPABILITY, this.lazyOptional.orElseThrow(() -> new NullPointerException("An error has occur during writing Radiation Effect Capability by Plant Tech 2")), null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        RADIATION_CAPABILITY.getStorage().readNBT(RADIATION_CAPABILITY, this.lazyOptional.orElseThrow(() -> new NullPointerException("An error has occur during reading Radiation Effect Capability by Plant Tech 2")), null, (INBT)nbt);
    }

    @Override
    public void setLevel(float level) {
        this.level = level < 0.0f ? 0.0f : Math.min(2.0f, level);
    }

    @Override
    public float getLevel() {
        return this.level;
    }

    @Override
    public void changeLevel(float amount) {
        this.level += amount;
        this.level = Math.min(Math.max(this.level, 0.0f), 2.0f);
    }

    public static class RadiationEffectStorage
    implements Capability.IStorage<IRadiationEffect> {
        @Nullable
        public INBT writeNBT(Capability<IRadiationEffect> capability, IRadiationEffect instance, Direction side) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74776_a("radiationeffect", instance.getLevel());
            return compound;
        }

        public void readNBT(Capability<IRadiationEffect> capability, IRadiationEffect instance, Direction side, INBT nbt) {
            instance.setLevel(((CompoundNBT)nbt).func_74760_g("radiationeffect"));
        }
    }
}

