/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.gui.GuideBaseScreen;
import net.kaneka.planttech2.gui.buttons.CustomButton;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuidePlantsScreen
extends GuideBaseScreen {
    private final String[] buttonEntryNames = new String[8];
    private ITextComponent selectedName = new StringTextComponent("");
    protected ItemStack primarySeed = ItemStack.field_190927_a;
    protected ItemStack soil = ItemStack.field_190927_a;
    protected ItemStack[] seeds = new ItemStack[9];
    protected DropEntry[] drops = new DropEntry[9];
    protected ItemStack[][] parents = new ItemStack[4][2];
    protected EnumTemperature temp = EnumTemperature.NORMAL;

    public GuidePlantsScreen() {
        super(PlantTechMain.getCropList().getLengthEnabledOnly() - 8, true, "screen.guideplants");
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int xPos = this.guiLeft + 28;
        int baseYPos = this.guiTop + 10;
        int width = 100;
        int height = 20;
        for (int id = 0; id < 8; ++id) {
            this.func_230480_a_((Widget)new CustomButton(id, xPos, baseYPos + id * 22, 100, 20, "Button " + (id + 1), this::buttonClicked));
        }
        this.updateButtons();
    }

    @Override
    protected void drawForeground(MatrixStack mStack) {
        if (this.hasSelection) {
            int i;
            GuidePlantsScreen.func_238463_a_((MatrixStack)mStack, (int)(this.guiLeft + 307), (int)(this.guiTop + 65), (float)0.0f, (float)(196 + 16 * this.temp.ordinal()), (int)16, (int)16, (int)512, (int)512);
            this.renderItem(this.primarySeed, 261, 32);
            if (!this.soil.func_190926_b()) {
                this.renderItem(this.soil, 217, 65);
            }
            for (i = 0; i < 9; ++i) {
                if (!this.seeds[i].func_190926_b()) {
                    this.renderItem(this.seeds[i], 189 + 18 * i, 98);
                }
                if (this.drops[i] == DropEntry.EMPTY) continue;
                this.renderItem(this.drops[i].getItemStack(), 189 + 18 * i, 131);
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0].func_190926_b()) continue;
                this.renderItem(this.parents[i][0], 162 + 56 * i, 164);
                this.renderItem(this.parents[i][1], 192 + 56 * i, 164);
            }
        }
    }

    @Override
    protected void updateButtons() {
        List<CropEntry> list = PlantTechMain.getCropList().values(false);
        for (int i = 0; i < 8; ++i) {
            if (this.scrollPos + i >= list.size()) continue;
            CropEntry entry = list.get(this.scrollPos + i);
            ((Widget)this.field_230710_m_.get(i)).func_238482_a_(entry.getDisplayName());
            this.buttonEntryNames[i] = entry.getName();
        }
    }

    @Override
    protected void drawStrings(MatrixStack mStack) {
        if (!this.hasSelection) {
            GuidePlantsScreen.func_238472_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.non_selected"), (int)(this.guiLeft + 255), (int)(this.guiTop + 90), (int)59395);
        } else {
            GuidePlantsScreen.func_238472_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.selectedName, (int)(this.guiLeft + 263), (int)(this.guiTop + 15), (int)59395);
            GuidePlantsScreen.func_238472_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.soil"), (int)(this.guiLeft + 223), (int)(this.guiTop + 54), (int)59395);
            GuidePlantsScreen.func_238472_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.temperature"), (int)(this.guiLeft + 306), (int)(this.guiTop + 54), (int)59395);
            GuidePlantsScreen.func_238472_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.seeds"), (int)(this.guiLeft + 263), (int)(this.guiTop + 87), (int)59395);
            GuidePlantsScreen.func_238472_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.drops"), (int)(this.guiLeft + 263), (int)(this.guiTop + 120), (int)59395);
            GuidePlantsScreen.func_238472_a_((MatrixStack)mStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.parents"), (int)(this.guiLeft + 263), (int)(this.guiTop + 153), (int)59395);
        }
    }

    protected void buttonClicked(CustomButton button) {
        int buttonID = button.id;
        if (buttonID >= 0 && buttonID < 8) {
            this.setItems(this.buttonEntryNames[buttonID]);
        }
    }

    protected void setItems(String entryName) {
        int j;
        CropEntry entry = PlantTechMain.getCropList().getByName(entryName);
        boolean bl = this.hasSelection = entry != null;
        if (!this.hasSelection) {
            return;
        }
        this.selectedName = entry.getDisplayName();
        this.primarySeed = entry.getPrimarySeed().getItemStack();
        this.temp = entry.getConfiguration().getTemperature();
        this.soil = new ItemStack((IItemProvider)entry.getConfiguration().getSoil().get());
        Arrays.fill(this.seeds, ItemStack.field_190927_a);
        Arrays.fill(this.drops, DropEntry.EMPTY);
        for (int k = 0; k < 4; ++k) {
            Arrays.fill(this.parents[k], ItemStack.field_190927_a);
        }
        List<Supplier<Item>> seeds = entry.getSeeds();
        List<DropEntry> drops = entry.getAdditionalDrops();
        List<ParentPair> parents = entry.getParents();
        this.seeds[0] = entry.getPrimarySeed().getItemStack();
        for (j = 0; j < 8 && j < seeds.size(); ++j) {
            this.seeds[j + 1] = new ItemStack((IItemProvider)seeds.get(j).get());
        }
        this.drops[0] = entry.getPrimarySeed();
        for (j = 0; j < 8 && j < drops.size(); ++j) {
            this.drops[j + 1] = drops.get(j);
        }
        for (j = 0; j < 4 && j < parents.size(); ++j) {
            ParentPair pair = parents.get(j);
            this.parents[j][0] = PlantTechMain.getCropList().getByName(pair.getFirstParent()).getPrimarySeed().getItemStack();
            this.parents[j][1] = PlantTechMain.getCropList().getByName(pair.getSecondParent()).getPrimarySeed().getItemStack();
        }
    }

    @Override
    protected void drawTooltips(MatrixStack mStack, int mouseX, int mouseY) {
        if (this.hasSelection) {
            int i;
            this.drawTooltip(mStack, this.primarySeed.func_200301_q(), mouseX, mouseY, 261, 32);
            if (!this.soil.func_190926_b()) {
                this.drawTooltip(mStack, this.soil.func_200301_q(), mouseX, mouseY, 217, 65);
            }
            this.drawTooltip(mStack, (ITextComponent)this.temp.getDisplayString(), mouseX, mouseY, 307, 65);
            for (i = 0; i < 9; ++i) {
                if (!this.seeds[i].func_190926_b()) {
                    this.drawTooltip(mStack, this.seeds[i].func_200301_q(), mouseX, mouseY, 189 + 18 * i, 98);
                }
                if (this.drops[i] == DropEntry.EMPTY) continue;
                this.drawTooltip(mStack, (ITextComponent)new StringTextComponent("").func_240702_b_(this.drops[i].getMin() + "-" + this.drops[i].getMax() + "x ").func_230529_a_(this.drops[i].getItem().get().func_199767_j().func_200296_o()), mouseX, mouseY, 189 + 18 * i, 131);
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0].func_190926_b()) continue;
                this.drawTooltip(mStack, this.parents[i][0].func_200301_q(), mouseX, mouseY, 162 + 56 * i, 164);
                this.drawTooltip(mStack, this.parents[i][1].func_200301_q(), mouseX, mouseY, 192 + 56 * i, 164);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.hasSelection && mouseButton == 0) {
            CropEntry entry;
            int i;
            Item clickedOn = null;
            if (this.inItemStackArea(mouseX, mouseY, 261, 32)) {
                clickedOn = this.primarySeed.func_77973_b();
            }
            if (this.inItemStackArea(mouseX, mouseY, 217, 65) && this.soil != null && !this.soil.func_190926_b()) {
                clickedOn = this.soil.func_77973_b();
            }
            for (i = 0; i < 9; ++i) {
                if (this.seeds[i] != null && this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 98)) {
                    clickedOn = this.seeds[i].func_77973_b();
                }
                if (this.drops[i] == null || !this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 131)) continue;
                clickedOn = this.drops[i].getItem().get().func_199767_j();
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0] == null) continue;
                if (this.inItemStackArea(mouseX, mouseY, 162 + 56 * i, 164)) {
                    clickedOn = this.parents[i][0].func_77973_b();
                }
                if (!this.inItemStackArea(mouseX, mouseY, 192 + 56 * i, 164)) continue;
                clickedOn = this.parents[i][1].func_77973_b();
            }
            if (clickedOn != null && (entry = PlantTechMain.getCropList().getBySeed(clickedOn)) != null) {
                this.setItems(entry.getName());
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private boolean inArea(double mouseX, double mouseY, int posX, int posY, int width, int height) {
        return mouseX >= (double)(posX += this.guiLeft) && mouseX <= (double)(posX + width) && mouseY >= (double)(posY += this.guiTop) && mouseY <= (double)(posY + height);
    }

    private boolean inItemStackArea(double mouseX, double mouseY, int posX, int posY) {
        return this.inArea(mouseX, mouseY, posX, posY, 16, 16);
    }

    @Override
    protected void drawBackground(MatrixStack mStack) {
        if (!this.hasSelection) {
            GuidePlantsScreen.func_238463_a_((MatrixStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)0.0f, (int)300, (int)this.ySize, (int)512, (int)512);
        } else {
            GuidePlantsScreen.func_238463_a_((MatrixStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)196.0f, (int)300, (int)this.ySize, (int)512, (int)512);
        }
        GuidePlantsScreen.func_238463_a_((MatrixStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }
}

