/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui.guide;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.gui.buttons.CustomButton;
import net.kaneka.planttech2.gui.guide.Guide;
import net.kaneka.planttech2.gui.guide.GuideEntry;
import net.kaneka.planttech2.gui.guide.GuideMenu;
import net.kaneka.planttech2.gui.guide.GuidePicture;
import net.kaneka.planttech2.gui.guide.GuideString;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuideScreen
extends Screen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2:textures/gui/guide.png");
    protected int xSize = 441;
    protected int ySize = 258;
    protected int guiLeft;
    protected int guiTop;
    protected final List<Widget> buttons_mainmenu = Lists.newArrayList();
    protected final List<Widget> buttons_entry = Lists.newArrayList();
    protected final List<Widget> buttons_navigation = Lists.newArrayList();
    private Guide guide = new Guide();
    int mode = 0;
    int menuid = 0;
    int entryid = 0;
    int page = 0;
    int maxPages = 0;
    int linesPerPage = 19;
    private List<GuideString> lines = new ArrayList<GuideString>();
    private List<GuidePicture> pics;

    public GuideScreen() {
        super((ITextComponent)new TranslationTextComponent("planttech2.guide"));
    }

    public GuideScreen(int menuid, int entryid) {
        this();
        this.mode = 2;
        this.menuid = menuid;
        this.entryid = entryid;
    }

    public void func_231160_c_() {
        int y;
        int x;
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 5; ++y) {
                this.addButtonList(this.buttons_mainmenu, 1, x * 5 + y, this.guiLeft + 50 + x * 200, this.guiTop + 35 + y * 37, 150, 35, this.translateUnformated("guide.planttech2.amenu"));
            }
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 5; ++y) {
                this.addButtonList(this.buttons_entry, 2, x * 5 + y, this.guiLeft + 50 + x * 200, this.guiTop + 35 + y * 37, 150, 20, this.translateUnformated("guide.planttech2.submenu"));
            }
        }
        this.addButtonList(this.buttons_navigation, 0, 0, this.guiLeft + 170, this.guiTop + 230, 100, 20, this.translateUnformated("gui.back"));
        this.addButtonList(this.buttons_navigation, 0, 1, this.guiLeft + 15, this.guiTop + 230, 100, 20, this.translateUnformated("gui.last"));
        this.addButtonList(this.buttons_navigation, 0, 2, this.guiLeft + 320, this.guiTop + 230, 100, 20, this.translateUnformated("gui.next"));
        this.deactivateButtonList(this.buttons_entry);
        this.deactivateButtonList(this.buttons_navigation);
        this.update(true);
    }

    protected void addButtonList(List<Widget> list, int buttontype, int id, int xPos, int yPos, int width, int height, String displayString) {
        CustomButton button = (CustomButton)this.func_230480_a_((Widget)new CustomButton(id, xPos, yPos, width, height, this.translateUnformated(displayString), btn -> this.buttonClicked(buttontype, id)));
        list.add((Widget)button);
    }

    protected void buttonClicked(int buttontype, int buttonid) {
        boolean modechange = false;
        if (buttontype == 0) {
            if (buttonid == 0) {
                if (this.mode >= 1) {
                    --this.mode;
                    this.page = 0;
                }
            } else if (buttonid == 1) {
                --this.page;
            } else if (buttonid == 2) {
                ++this.page;
            }
        } else {
            modechange = true;
            this.mode = buttontype;
            if (this.mode == 1) {
                this.menuid = buttonid;
            } else if (this.mode == 2) {
                this.entryid = buttonid + this.page * 10;
            }
        }
        this.update(modechange);
    }

    private void activateButton(Widget button) {
        button.field_230693_o_ = true;
        button.field_230694_p_ = true;
    }

    private void deactivateButton(Widget button) {
        button.field_230693_o_ = false;
        button.field_230694_p_ = false;
    }

    private void activateButtonList(List<Widget> list) {
        for (Widget button : list) {
            this.activateButton(button);
        }
    }

    private void deactivateButtonList(List<Widget> list) {
        for (Widget button : list) {
            this.deactivateButton(button);
        }
    }

    private void update(boolean modechange) {
        this.deactivateButtonList(this.field_230710_m_);
        if (this.mode == 0) {
            for (int i = 0; i < this.buttons_mainmenu.size(); ++i) {
                Widget button = this.buttons_mainmenu.get(i);
                if (i >= this.guide.getAmountMainMenus()) continue;
                this.activateButton(button);
                button.func_238482_a_((ITextComponent)new StringTextComponent(this.guide.getMenuById(i).getName()));
            }
        } else if (this.mode == 1) {
            GuideMenu menu = this.guide.getMenuById(this.menuid);
            this.maxPages = menu.getAmountEntrys() / 8;
            for (int i = 0; i < this.buttons_entry.size(); ++i) {
                Widget button = this.buttons_entry.get(i);
                if (i + this.page * 10 >= menu.getAmountEntrys()) continue;
                this.activateButton(button);
                button.func_238482_a_((ITextComponent)new StringTextComponent(menu.getEntryById(i + this.page * 10).getName()));
            }
            this.activateButton(this.buttons_navigation.get(0));
            if (this.page > 0) {
                this.activateButton(this.buttons_navigation.get(1));
            }
            if (this.maxPages - 1 > this.page) {
                this.activateButton(this.buttons_navigation.get(2));
            }
        } else if (this.mode == 2) {
            this.activateButton(this.buttons_navigation.get(0));
            if (modechange) {
                this.loadEntry();
            }
            if (this.page > 0) {
                this.activateButton(this.buttons_navigation.get(1));
            }
            if (this.maxPages - 1 > this.page) {
                this.activateButton(this.buttons_navigation.get(2));
            }
        }
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        this.drawBackground(mStack);
        this.drawForeground(mStack);
        this.drawButtons(mStack, mouseX, mouseY, partialTicks);
        this.drawStrings(mStack);
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawButtons(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get(i)).func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground(MatrixStack mStack) {
        GuideScreen.func_238463_a_((MatrixStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)512);
    }

    protected void drawForeground(MatrixStack mStack) {
        if (this.mode == 2 && !this.pics.isEmpty() && this.page == 0) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (GuidePicture pic : this.pics) {
                this.field_230706_i_.func_110434_K().func_110577_a(pic.getResloc());
                GuideScreen.func_238463_a_((MatrixStack)mStack, (int)(this.guiLeft + pic.getXStart() + 25), (int)(this.guiTop + pic.getYStart() + 30), (float)0.0f, (float)0.0f, (int)pic.getWidth(), (int)pic.getHeight(), (int)pic.getWidth(), (int)pic.getHeight());
            }
        }
    }

    protected void drawStrings(MatrixStack mStack) {
        if (this.mode == 0) {
            this.drawCenteredString(mStack, this.translateUnformated("guide.planttech2.header"), this.guiLeft + this.xSize / 2, this.guiTop + 15);
        } else if (this.mode == 1) {
            this.drawCenteredString(mStack, this.guide.getMenuById(this.menuid).getName(), this.guiLeft + this.xSize / 2, this.guiTop + 15);
        } else if (this.mode == 2) {
            this.drawCenteredString(mStack, this.guide.getMenuById(this.menuid).getEntryById(this.entryid).getHeader().getString(), this.guiLeft + this.xSize / 2, this.guiTop + 15);
            for (int i = 0; i < this.lines.size(); ++i) {
                GuideString guideString = this.lines.get(i);
                if (this.page * 19 > guideString.getLine() || guideString.getLine() >= this.page * 19 + 19) continue;
                this.drawLine(mStack, guideString.getString(), this.guiLeft + 25 + guideString.getX(), this.guiTop + 30 + 10 * (guideString.getLine() - 19 * this.page));
            }
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
    }

    protected String translateUnformated(String name) {
        return new TranslationTextComponent(name).getString();
    }

    protected void drawCenteredString(MatrixStack mStack, String string, int posX, int posY) {
        this.field_230712_o_.func_238421_b_(mStack, string, (float)(posX - this.field_230712_o_.func_78256_a(string) / 2), (float)posY, Integer.parseInt("000000", 16));
    }

    protected void drawLine(MatrixStack mStack, String text, int x, int y) {
        this.field_230712_o_.func_238421_b_(mStack, text, (float)x, (float)y, Integer.parseInt("000000", 16));
    }

    protected void loadEntry() {
        GuideEntry entry = this.guide.getMenuById(this.menuid).getEntryById(this.entryid);
        this.pics = entry.getPictures();
        this.lines = entry.getTextFormated(this.field_230712_o_);
        this.page = 0;
        this.maxPages = (int)Math.ceil((double)this.lines.size() / (double)this.linesPerPage);
    }
}

