/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CropRemover
extends Item {
    public CropRemover() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ModCreativeTabs.MAIN).func_200918_c(1024));
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld world = source.func_197524_h();
                BlockPos target = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                this.func_239796_a_(CropRemover.applyCropRemove((World)world, target, stack));
                if (!world.func_201670_d() && this.func_239795_a_()) {
                    stack.func_196085_b(stack.func_77952_i() + 1);
                    if (stack.func_77952_i() >= stack.func_77958_k()) {
                        stack.func_190918_g(1);
                    }
                    world.func_217379_c(2005, target, 0);
                }
                return stack;
            }
        });
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (!world.field_72995_K && CropRemover.applyCropRemove(world, pos, stack)) {
            if (player != null && !player.field_71075_bZ.field_75098_d) {
                stack.func_222118_a(1, (LivingEntity)player, player2 -> player2.func_213334_d(context.func_221531_n()));
                if (stack.func_77952_i() >= stack.func_77958_k()) {
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.CONSUME;
        }
        return super.func_195939_a(context);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Rightclick on cropbars to remove crop"));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static boolean applyCropRemove(World world, BlockPos pos, ItemStack stack) {
        BlockState state = world.func_180495_p(pos);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof CropsTileEntity) {
            ArrayList drops = Lists.newArrayList();
            int growstate = (Integer)state.func_177229_b((Property)CropBaseBlock.GROWSTATE);
            ((CropsTileEntity)tileentity).addDrops(drops, growstate);
            for (ItemStack drop : drops) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            world.func_175656_a(pos, ModBlocks.CROPBARS.func_176223_P());
            return true;
        }
        return false;
    }
}

