/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CropSeedItem
extends Item {
    private final String entryName;
    private int TRAIT_MIN = 0;
    private int TRAIT_MAX = 1;

    public CropSeedItem(String entryName) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.SEEDS));
        this.entryName = entryName;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld world = source.func_197524_h();
                BlockPos target = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                this.func_239796_a_(CropSeedItem.plant((World)world, target, stack));
                if (!world.func_201670_d() && this.func_239795_a_()) {
                    world.func_217379_c(2005, target, 0);
                }
                return stack;
            }
        });
    }

    public String getEntryName() {
        return this.entryName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_74767_n("analysed")) {
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.type").getString() + ": " + nbt.func_74779_i("type")));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.soil").getString() + ": " + CropSeedItem.getSoilString(nbt.func_74779_i("type"))));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.temperature").getString() + ": ").func_230529_a_(CropSeedItem.temperatureString(nbt.func_74779_i("type"), nbt.func_74762_e("temperaturetolerance"))));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "growspeed") + new TranslationTextComponent("info.growspeed").getString() + ": " + nbt.func_74762_e("growspeed")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "sensitivity") + new TranslationTextComponent("info.sensitivity").getString() + ": " + nbt.func_74762_e("sensitivity")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "lightsensitivity") + new TranslationTextComponent("info.needed_lightlevel").getString() + ": " + (14 - nbt.func_74762_e("lightsensitivity"))));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "watersensitivity") + new TranslationTextComponent("info.waterrange").getString() + ": " + (1 + nbt.func_74762_e("watersensitivity"))));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "productivity") + new TranslationTextComponent("info.productivity").getString() + ": " + nbt.func_74762_e("productivity")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "fertility") + new TranslationTextComponent("info.fertility").getString() + ": " + nbt.func_74762_e("fertility")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "spreedingspeed") + new TranslationTextComponent("info.spreedingspeed").getString() + ": " + nbt.func_74762_e("spreedingspeed")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "genestrenght") + new TranslationTextComponent("info.genestrength").getString() + ": " + nbt.func_74762_e("genestrenght")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "energyvalue") + new TranslationTextComponent("info.energyvalue").getString() + ": " + nbt.func_74762_e("energyvalue") * 20));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.type").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.soil").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.temperaturetolerance").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.growspeed").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.sensitivity").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.needed_lightlevel").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.waterrange").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.productivity").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.fertility").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.spreedingspeed").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.genestrength").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.energyvalue").getString() + ": " + new TranslationTextComponent("info.unknown").getString()));
            }
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.type").getString() + ": " + this.entryName));
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.soil").getString() + ": " + CropSeedItem.getSoilString(this.entryName)));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.growspeed").getString() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.sensitivity").getString() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.needed_lightlevel").getString() + ": " + 14));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.waterrange").getString() + ": " + 1));
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.temperaturetolerance").getString() + ": ").func_230529_a_(CropSeedItem.temperatureString(this.entryName, 0)));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.productivity").getString() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.fertility").getString() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.spreedingspeed").getString() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.genestrength").getString() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.energyvalue").getString() + ": " + 20));
        }
    }

    public static ITextComponent temperatureString(String type, int tolerance) {
        if (tolerance == 0) {
            return PlantTechMain.getCropList().getByName(type).getConfiguration().getTemperature().getDisplayString();
        }
        int id = PlantTechMain.getCropList().getByName(type).getConfiguration().getTemperature().ordinal();
        int min = id - tolerance;
        int max = id + tolerance;
        if (min < 0) {
            min = 0;
        }
        if (max > 4) {
            max = 4;
        }
        return EnumTemperature.values()[min].getDisplayString().func_240702_b_(" - ").func_230529_a_((ITextComponent)EnumTemperature.values()[max].getDisplayString());
    }

    public static String getSoilString(String type) {
        Block soil = PlantTechMain.getCropList().getByName(type).getConfiguration().getSoil().get();
        return soil.func_235333_g_().getString();
    }

    private TextFormatting getTraitColor(CompoundNBT nbt, String trait) {
        if (nbt.func_74762_e(trait) == Objects.requireNonNull(EnumTraitsInt.getByName(trait)).getMax()) {
            return this.getTraitColor(this.TRAIT_MAX);
        }
        if (nbt.func_74762_e(trait) == Objects.requireNonNull(EnumTraitsInt.getByName(trait)).getMin()) {
            return this.getTraitColor(this.TRAIT_MIN);
        }
        return TextFormatting.RESET;
    }

    private TextFormatting getTraitColor(int level) {
        if (level == this.TRAIT_MIN) {
            return TextFormatting.GRAY;
        }
        if (level == this.TRAIT_MAX) {
            return TextFormatting.GREEN;
        }
        return TextFormatting.RESET;
    }

    public static boolean plant(World world, BlockPos pos, ItemStack stack) {
        CropEntry entry = PlantTechMain.getCropList().getBySeed(stack.func_77973_b());
        if (entry == null) {
            return false;
        }
        world.func_175656_a(pos, ModBlocks.CROPS.get(entry.getName()).func_176223_P());
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof CropsTileEntity) {
            HashMapCropTraits toPass = new HashMapCropTraits();
            toPass.setType(entry.getName());
            if (stack.func_77942_o()) {
                toPass.fromStack(stack);
            } else {
                toPass.setAnalysed(true);
            }
            ((CropsTileEntity)tileentity).setTraits(toPass);
            ((CropsTileEntity)tileentity).setStartTick();
            return true;
        }
        return false;
    }

    public static class ColorHandler
    implements IItemColor {
        public int getColor(ItemStack stack, int color) {
            return PlantTechMain.getCropList().getByName(((CropSeedItem)stack.func_77973_b()).getEntryName()).getSeedColor();
        }
    }
}

