/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.energy.EnergyProvider;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageItem
extends Item
implements IItemChargeable {
    private int basecapacity;

    public EnergyStorageItem(Item.Properties property, int basecapacity) {
        super(property.func_200917_a(1));
        this.basecapacity = basecapacity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new EnergyProvider(this.basecapacity);
    }

    @Override
    public int extractEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.extractEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int receiveEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.receiveEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int maxEnergy(ItemStack stack) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public int currentEnergy(ItemStack stack) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public static IEnergyStorage getEnergyCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityEnergy.ENERGY);
        if (provider.isPresent()) {
            return (IEnergyStorage)provider.orElse(null);
        }
        return null;
    }

    protected void updateEnergy(ItemStack stack) {
        IEnergyStorage storage;
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        if ((storage = EnergyStorageItem.getEnergyCap(stack)) instanceof BioEnergyStorage) {
            tag.func_74768_a("current_energy", ((BioEnergyStorage)storage).getEnergyStored());
            tag.func_74768_a("max_energy", ((BioEnergyStorage)storage).getMaxEnergyStored());
        }
        stack.func_77982_d(tag);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tooltip.add((ITextComponent)new StringTextComponent(tag.func_74762_e("current_energy") + "/" + tag.func_74762_e("max_energy") + " BE"));
        } else {
            this.updateEnergy(stack);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return 1.0 - (double)tag.func_74762_e("current_energy") / (double)tag.func_74762_e("max_energy");
        }
        this.updateEnergy(stack);
        return 1.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Integer.parseInt("06bc00", 16);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == this.field_77701_a) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack full = new ItemStack((IItemProvider)this);
            this.receiveEnergy(full, this.maxEnergy(full), false);
            items.add((Object)full);
        }
    }
}

