/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class CropConfigChangeMessage {
    private final Map<ResourceLocation, CropEntryConfigData> configData;

    public CropConfigChangeMessage(Map<ResourceLocation, CropEntryConfigData> configData) {
        this.configData = configData;
    }

    public static void encode(CropConfigChangeMessage pkt, PacketBuffer buf) {
        buf.func_150787_b(pkt.configData.size());
        for (Map.Entry<ResourceLocation, CropEntryConfigData> entry : pkt.configData.entrySet()) {
            buf.func_192572_a(entry.getKey());
            CropEntryConfigData.Serializer.INSTANCE.write(entry.getValue(), buf);
        }
    }

    public static CropConfigChangeMessage decode(PacketBuffer buf) {
        HashMap<ResourceLocation, CropEntryConfigData> configData = new HashMap<ResourceLocation, CropEntryConfigData>();
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            ResourceLocation name = buf.func_192575_l();
            configData.put(name, CropEntryConfigData.Serializer.INSTANCE.read(buf));
        }
        return new CropConfigChangeMessage(configData);
    }

    public static void handle(CropConfigChangeMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlantTechMain.LOGGER.debug("Syncing crop configurations from server");
            PlantTechMain.getCropList().configureFromConfigData(pkt.configData.values());
        });
        ctx.get().setPacketHandled(true);
    }
}

