/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import java.util.function.Supplier;
import net.kaneka.planttech2.entities.capabilities.techvillagertrust.TechVillagerTrust;
import net.kaneka.planttech2.entities.passive.TechVillagerEntity;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTrade;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PlayerInventoryUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class DoTechVillagerTradeMessage {
    private final TechVillagerTrade trade;
    private final int profession;

    public DoTechVillagerTradeMessage(TechVillagerTrade trade, int profession) {
        this.trade = trade;
        this.profession = profession;
    }

    public static void encode(DoTechVillagerTradeMessage pkt, PacketBuffer buf) {
        pkt.trade.toBuffer(buf);
        buf.writeInt(pkt.profession);
    }

    public static DoTechVillagerTradeMessage decode(PacketBuffer buf) {
        return new DoTechVillagerTradeMessage(TechVillagerTrade.fromBuffer(buf), buf.readInt());
    }

    public static void handle(DoTechVillagerTradeMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            PlayerInventory inv = sender.field_71071_by;
            TechVillagerTrade trade = pkt.trade;
            sender.getCapability(TechVillagerTrust.INSTANCE).ifPresent(trust -> {
                boolean success = trust.getLevel(TechVillagerEntity.getProfessionString(pkt.profession)) >= trade.getNeededLevel();
                success = success && PlayerInventoryUtils.enoughSpace(inv, trade.getOutputs().size());
                success = success && PlayerInventoryUtils.hasList(inv, trade.getInputs());
                boolean bl = success = success && PlayerInventoryUtils.enoughCredits(inv, trade.getCreditsBuy());
                if (success) {
                    if (trade.getCreditsSell() > 0 && inv.func_213901_a((Item)ModItems.PLANTCARD) > 0) {
                        if (PlayerInventoryUtils.removeCredits(inv, trade.getCreditsBuy()) && PlayerInventoryUtils.removeList(inv, trade.getInputs())) {
                            PlayerInventoryUtils.addList(inv, trade.getOutputs());
                            PlayerInventoryUtils.addCredits(inv, trade.getCreditsSell());
                        }
                    } else if (trade.getCreditsSell() == 0 && PlayerInventoryUtils.removeCredits(inv, trade.getCreditsBuy()) && PlayerInventoryUtils.removeList(inv, trade.getInputs())) {
                        PlayerInventoryUtils.addList(inv, trade.getOutputs());
                    }
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

