/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.utilities.TagUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChipalyzerRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final ItemStack chip;
    private final ItemStack input;
    private final Enchantment enchantment;
    private final ItemStack output;

    public ChipalyzerRecipe(ResourceLocation id, ItemStack chip, ItemStack input, Enchantment enchantment, ItemStack output) {
        this.id = id;
        this.chip = chip;
        this.input = input;
        this.enchantment = enchantment;
        this.output = output;
    }

    public ItemStack getChip() {
        return this.chip;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean compare(ItemStack chip, ItemStack stack) {
        if (!stack.func_190926_b() && !chip.func_190926_b()) {
            List<Enchantment> stackench;
            if (this.enchantment != null && (stackench = this.getEnchList(stack)).contains(this.enchantment)) {
                return true;
            }
            if (!this.input.func_190926_b()) {
                return this.input.func_77973_b() == stack.func_77973_b();
            }
        }
        return false;
    }

    public List<Enchantment> getEnchList(ItemStack stack) {
        ArrayList<Enchantment> list;
        block4: {
            list = new ArrayList<Enchantment>();
            if (stack == null || stack.func_190926_b()) break block4;
            if (stack.func_77973_b() == Items.field_151134_bR) {
                for (INBT nbt : EnchantedBookItem.func_92110_g((ItemStack)stack)) {
                    CompoundNBT compoundnbt;
                    if (!(nbt instanceof CompoundNBT) || !(compoundnbt = (CompoundNBT)nbt).func_74764_b("id") || !ForgeRegistries.ENCHANTMENTS.containsKey(new ResourceLocation(compoundnbt.func_74779_i("id")))) continue;
                    list.add((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(compoundnbt.func_74779_i("id"))));
                }
            } else {
                for (Enchantment entry : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
                    list.add(entry);
                }
            }
        }
        return list;
    }

    public boolean compareEnchantment(ListNBT nbt) {
        return this.input.func_77986_q() == nbt;
    }

    public List<ItemStack> getComponents() {
        ArrayList<ItemStack> components = new ArrayList<ItemStack>();
        components.add(this.chip);
        if (this.input == ItemStack.field_190927_a) {
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            book.func_77966_a(this.enchantment, 1);
            components.add(book);
        } else {
            components.add(this.input);
        }
        return components;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.input.func_77973_b() == inv.func_70301_a(0).func_77973_b();
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output;
    }

    public boolean func_194133_a(int width, int height) {
        return width == height && width == 1;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.CHIPALYZER;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.CHIPALYZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ChipalyzerRecipe> {
        public ChipalyzerRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputobject;
            ItemStack chip = ItemStack.field_190927_a;
            if (json.has("chip") && (inputobject = json.getAsJsonObject("chip")).has("item")) {
                chip = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("item").getAsString())));
            }
            ItemStack input = ItemStack.field_190927_a;
            Enchantment enchantment = null;
            if (json.has("input")) {
                ResourceLocation namespaced_id;
                JsonObject inputobject2 = json.getAsJsonObject("input");
                if (inputobject2.has("item")) {
                    input = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject2.get("item").getAsString())));
                } else if (inputobject2.has("block")) {
                    input = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject2.get("block").getAsString())));
                } else if (inputobject2.has("tag")) {
                    input = new ItemStack((IItemProvider)TagUtils.getAnyTagItem(new ResourceLocation(inputobject2.get("tag").getAsString())));
                }
                if (inputobject2.has("enchantment") && ForgeRegistries.ENCHANTMENTS.containsKey(namespaced_id = new ResourceLocation(inputobject2.get("enchantment").getAsString()))) {
                    enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(namespaced_id);
                }
            }
            JsonObject resultobject = json.getAsJsonObject("result");
            Item result = null;
            if (resultobject.has("item")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("item").getAsString()));
            } else if (resultobject.has("block")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("block").getAsString()));
            } else if (resultobject.has("tag")) {
                result = TagUtils.getAnyTagItem(new ResourceLocation(resultobject.get("tag").getAsString()));
            }
            if (result != null) {
                return new ChipalyzerRecipe(recipeId, chip, input, enchantment, new ItemStack((IItemProvider)result));
            }
            throw new IllegalStateException("Item did not exist:" + recipeId.toString());
        }

        public ChipalyzerRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ItemStack chip = buffer.func_150791_c();
            ItemStack input = buffer.func_150791_c();
            String ench = buffer.func_218666_n();
            Enchantment enchantment = null;
            if (!ench.equals("null")) {
                enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(ench));
            }
            ItemStack result = buffer.func_150791_c();
            return new ChipalyzerRecipe(recipeId, chip, input, enchantment, result);
        }

        public void write(PacketBuffer buffer, ChipalyzerRecipe recipe) {
            buffer.func_150788_a(recipe.chip);
            buffer.func_150788_a(recipe.input);
            if (recipe.enchantment != null) {
                buffer.func_180714_a(recipe.enchantment.getRegistryName().toString());
            } else {
                buffer.func_180714_a("null");
            }
            buffer.func_150788_a(recipe.output);
        }
    }
}

