/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonObject;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.utilities.TagUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfuserRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final Item input;
    private final Item output;
    private final int biomass;

    public InfuserRecipe(ResourceLocation id, Item input, Item output, int biomass) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.biomass = biomass;
    }

    public Item getInput() {
        return this.input;
    }

    public ItemStack getInputStack() {
        return new ItemStack((IItemProvider)this.input);
    }

    public Item getOutput() {
        return this.output;
    }

    public int getBiomass() {
        return this.biomass;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.input.getItem() == inv.func_70301_a(0).func_77973_b();
    }

    public ItemStack func_77572_b(IInventory inv) {
        return new ItemStack((IItemProvider)this.output);
    }

    public boolean func_194133_a(int width, int height) {
        return width == height && width == 1;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.output);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.INFUSER;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.INFUSING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfuserRecipe> {
        public InfuserRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputobject = json.getAsJsonObject("input");
            Item input = null;
            if (inputobject.has("item")) {
                input = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("item").getAsString()));
            } else if (inputobject.has("block")) {
                input = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("block").getAsString()));
            } else if (inputobject.has("tag")) {
                input = TagUtils.getAnyTagItem(new ResourceLocation(inputobject.get("tag").getAsString()));
            }
            int biomass = inputobject.get("biomass").getAsInt();
            JsonObject resultobject = json.getAsJsonObject("result");
            Item result = null;
            if (resultobject.has("item")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("item").getAsString()));
            } else if (resultobject.has("block")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("block").getAsString()));
            } else if (resultobject.has("tag")) {
                result = TagUtils.getAnyTagItem(new ResourceLocation(resultobject.get("tag").getAsString()));
            }
            if (input != null && result != null) {
                return new InfuserRecipe(recipeId, input, result, biomass);
            }
            throw new IllegalStateException("Item did not exist:" + recipeId.toString());
        }

        public InfuserRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Item input = buffer.func_150791_c().func_77973_b();
            Item result = buffer.func_150791_c().func_77973_b();
            int biomass = buffer.readInt();
            return new InfuserRecipe(recipeId, input, result, biomass);
        }

        public void write(PacketBuffer buffer, InfuserRecipe recipe) {
            buffer.func_150788_a(new ItemStack((IItemProvider)recipe.input));
            buffer.func_150788_a(new ItemStack((IItemProvider)recipe.output));
            buffer.writeInt(recipe.biomass);
        }
    }
}

