/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.registries;

import java.util.function.Consumer;
import net.kaneka.planttech2.entities.neutral.TechGhoulEntity;
import net.kaneka.planttech2.entities.passive.TechPenguinEntity;
import net.kaneka.planttech2.entities.passive.TechVillagerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="planttech2")
public class ModEntityTypes {
    @ObjectHolder(value="planttech2:techvillager")
    public static EntityType<TechVillagerEntity> TECHVILLAGERENTITY;
    @ObjectHolder(value="planttech2:techghoul")
    public static EntityType<TechGhoulEntity> TECHGHOULENTITY;
    @ObjectHolder(value="planttech2:techpenguin")
    public static EntityType<TechPenguinEntity> TECHPENGUINENTITY;

    public static void registerAll(IForgeRegistry<EntityType<?>> registry) {
        registry.register(ModEntityTypes.make("planttech2:techvillager", TechVillagerEntity::new, EntityClassification.MISC, factory -> factory.func_220321_a(0.6f, 1.95f).setUpdateInterval(3).setTrackingRange(16).setShouldReceiveVelocityUpdates(true)));
        registry.register(ModEntityTypes.make("planttech2:techghoul", TechGhoulEntity::new, EntityClassification.MISC, factory -> factory.func_220321_a(0.9f, 1.8f)));
        registry.register(ModEntityTypes.make("planttech2:techpenguin", TechPenguinEntity::new, EntityClassification.MISC, factory -> factory.func_220321_a(0.5f, 1.5f)));
    }

    static <T extends Entity> EntityType<T> make(String registryName, EntityType.IFactory<T> factory, EntityClassification classification, Consumer<EntityType.Builder<T>> customizer) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        customizer.accept(builder);
        EntityType type = builder.func_206830_a(registryName);
        type.setRegistryName(registryName);
        return type;
    }
}

