/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.cable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.cable.CableInfo;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TestCableTileEntity
extends TileEntity
implements ITickableTileEntity {
    public CableInfo cableInfo = new CableInfo();
    public int maxTransferRate = 20;

    public TestCableTileEntity() {
        super(ModTileEntities.CABLE_TE);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && this.isMaster()) {
            this.transferEnergy();
        }
    }

    private void transferEnergy() {
        AtomicInteger energyRequired = new AtomicInteger();
        AtomicInteger energySupplied = new AtomicInteger();
        for (CableInfo.Connection consumer : this.info().consumers) {
            this.receiveEnergy(consumer, capability -> energyRequired.addAndGet(capability.receiveEnergy(this.getMaxTransferRate(), true)));
        }
        for (CableInfo.Connection producer : this.info().producers) {
            this.extractEnergy(producer, capability -> energySupplied.addAndGet(capability.extractEnergy(this.getMaxTransferRate(), true)));
        }
        AtomicInteger energyAvailable = new AtomicInteger(Math.min(energySupplied.get(), energyRequired.get()));
        AtomicInteger energyAvailable2 = new AtomicInteger(energyAvailable.get());
        for (CableInfo.Connection consumer : this.info().consumers) {
            this.receiveEnergy(consumer, capability -> energyAvailable.addAndGet(-capability.receiveEnergy(Math.min(energyAvailable.get(), this.getMaxTransferRate()), false)));
        }
        for (CableInfo.Connection producer : this.info().producers) {
            this.extractEnergy(producer, capability -> energyAvailable2.addAndGet(-capability.extractEnergy(Math.min(energyAvailable2.get(), this.getMaxTransferRate()), false)));
        }
    }

    private void receiveEnergy(CableInfo.Connection consumer, Consumer<IEnergyStorage> transfer) {
        IEnergyStorage capability = this.getEnergyCap(consumer.blockPos, consumer.direction.func_176734_d());
        if (capability != null && capability.canReceive()) {
            transfer.accept(capability);
        }
    }

    private void extractEnergy(CableInfo.Connection producer, Consumer<IEnergyStorage> transfer) {
        IEnergyStorage capability = this.getEnergyCap(producer.blockPos, producer.direction.func_176734_d());
        if (capability != null && capability.canExtract()) {
            transfer.accept(capability);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("cableinfo", (INBT)this.cableInfo.write());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.cableInfo = new CableInfo(nbt.func_74775_l("cableinfo"));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        if (this.field_145850_b != null) {
            this.handleUpdateTag(this.field_145850_b.func_180495_p(packet.func_179823_a()), packet.func_148857_g());
        }
    }

    public void initCable() {
        this.checkConnections();
        ArrayList<BlockPos> masters = new ArrayList<BlockPos>();
        this.getAllConnected(cable -> {
            BlockPos masterPos = cable.getMasterPos();
            if (!masters.contains(masterPos)) {
                masters.add(masterPos);
            }
        });
        if (!masters.isEmpty()) {
            if (masters.size() == 1) {
                TestCableTileEntity master = this.getCableTE(masters.get(0));
                if (master != null) {
                    master.addCableToNetwork(this);
                }
                return;
            }
            TestCableTileEntity largestNetwork = this.getLargestNetwork(masters);
            if (largestNetwork != null) {
                largestNetwork.addCableToNetwork(this);
                masters.remove(largestNetwork.func_174877_v());
                masters.forEach(pos -> largestNetwork.mergeNetworks(this.getCableTE((BlockPos)pos)));
                return;
            }
        }
        this.createNetwork();
    }

    public void addCableToNetwork(TestCableTileEntity cable) {
        if (!this.isMaster()) {
            return;
        }
        this.info().slaves.add(cable.func_174877_v());
        cable.updateMaster(this);
        this.addMachinesFrom(cable);
    }

    public List<BlockPos> getAllConnections(BlockPos master) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(master);
        return this.getAllConnections(positions);
    }

    public List<BlockPos> getAllConnections(HashSet<BlockPos> connected) {
        return this.getAllConnections(new ArrayList<BlockPos>(connected));
    }

    public List<BlockPos> getAllConnections(ArrayList<BlockPos> connected) {
        for (Direction direction : Direction.values()) {
            TestCableTileEntity cable;
            BlockPos pos = this.func_174877_v().func_177972_a(direction);
            if (connected.contains(pos) || (cable = this.getCableTE(pos)) == null) continue;
            connected.add(pos);
            cable.getAllConnections(connected);
        }
        return connected;
    }

    public void refresh() {
        if (this.field_145850_b == null || !this.isMaster()) {
            return;
        }
        this.clear(true);
        this.setIsMaster(true);
        this.getAllConnections(this.func_174877_v()).forEach(pos -> {
            TestCableTileEntity cable;
            if (!pos.equals((Object)this.func_174877_v()) && (cable = this.getCableTE((BlockPos)pos)) != null) {
                this.info().slaves.add((BlockPos)pos);
                cable.updateMaster(this);
                this.addMachinesFrom(cable);
            }
        });
        this.addMachinesFrom(this);
    }

    public void addMachinesFrom(TestCableTileEntity cable) {
        int[] connections = cable.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            CableInfo.Connection connection = new CableInfo.Connection(cable.func_174877_v().func_177972_a(Direction.func_82600_a((int)i)), Direction.func_82600_a((int)i));
            if (connections[i] < 2) {
                this.removeConsumer(connection);
                this.removeProducer(connection);
            }
            if (connections[i] == 2) {
                this.addConsumer(connection);
            }
            if (connections[i] != 3) continue;
            this.addProducer(connection);
        }
    }

    public void createNetwork() {
        if (this.field_145850_b == null) {
            return;
        }
        this.setIsMaster(true);
        this.refresh();
    }

    @Nullable
    public TestCableTileEntity getLargestNetwork(ArrayList<BlockPos> masterPositions) {
        BlockPos largest = BlockPos.field_177992_a;
        for (BlockPos pos : masterPositions) {
            TestCableTileEntity largestCable = this.getCableTE(largest);
            TestCableTileEntity targetCable = this.getCableTE(pos);
            if (largestCable != null) {
                if (targetCable == null || largestCable.info().slaves.size() >= targetCable.info().slaves.size()) continue;
                largest = pos;
                continue;
            }
            if (targetCable == null) continue;
            largest = pos;
        }
        return largest.equals((Object)BlockPos.field_177992_a) ? null : this.getCableTE(largest);
    }

    public void checkConnections() {
        if (this.field_145850_b == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
            if (te != null) {
                if (te instanceof TestCableTileEntity) {
                    if (this.getConnection(direction) == 1) continue;
                    this.setConnection(direction, 1);
                    continue;
                }
                if (!te.getCapability(CapabilityEnergy.ENERGY, direction).isPresent() || this.getConnection(direction) >= 2) continue;
                this.setConnection(direction, 2);
                continue;
            }
            if (this.getConnection(direction) == 0) continue;
            this.setConnection(direction, 0);
        }
    }

    public void func_145843_s() {
        this.forceReplaceMaster();
    }

    public void forceReplaceMaster() {
        if (this.field_145850_b == null) {
            return;
        }
        for (BlockPos slave : this.info().slaves) {
            TestCableTileEntity cable2 = this.getCableTE(slave);
            if (cable2 == null) continue;
            cable2.clear(true);
        }
        this.getAllConnected(cable -> {
            if (cable.getMasterPos().equals((Object)BlockPos.field_177992_a)) {
                cable.createNetwork();
            }
        });
    }

    public void findNewMaster() {
        TestCableTileEntity cable;
        if (this.field_145850_b == null || !this.isMaster()) {
            return;
        }
        ArrayList<BlockPos> slaves = new ArrayList<BlockPos>(this.info().slaves);
        if (!slaves.isEmpty() && (cable = this.getCableTE(slaves.get(0))) != null) {
            cable.setAsMaster(this);
        }
    }

    public void mergeNetworks(TestCableTileEntity otherMaster) {
        if (this.field_145850_b == null || !this.info().isMaster || otherMaster == null) {
            return;
        }
        CableInfo i = otherMaster.info();
        this.info().slaves.addAll(i.slaves);
        this.info().producers.addAll(i.producers);
        this.info().consumers.addAll(i.consumers);
        this.info().storages.addAll(i.storages);
        otherMaster.clear(true);
        this.info().slaves.add(otherMaster.func_174877_v());
        this.updateSlavesMasterInfo();
    }

    public void setAsMaster(@Nullable TestCableTileEntity oldMaster) {
        if (this.field_145850_b == null) {
            return;
        }
        this.setIsMaster(true);
        if (oldMaster != null) {
            CableInfo i = oldMaster.info();
            this.info().masterPos = oldMaster.func_174877_v();
            this.info().slaves = i.slaves;
            this.info().producers = i.producers;
            this.info().consumers = i.consumers;
            this.info().storages = i.storages;
            this.updateSlavesMasterInfo();
        }
    }

    public void updateMaster(TestCableTileEntity master) {
        this.updateMaster(master.func_174877_v());
    }

    public void updateMaster(BlockPos master) {
        this.info().masterPos = master;
        this.info().isMaster = false;
    }

    public void updateSlavesMasterInfo() {
        if (!this.isMaster()) {
            return;
        }
        this.info().slaves.forEach(slave -> {
            TestCableTileEntity cable = this.getCableTE((BlockPos)slave);
            if (cable != null) {
                cable.updateMaster(this);
            }
        });
    }

    public boolean getAllConnected(Consumer<TestCableTileEntity> message) {
        boolean changed = false;
        for (Direction direction : Direction.values()) {
            TestCableTileEntity cable = this.getCableTE(this.func_174877_v().func_177972_a(direction));
            if (cable == null) continue;
            message.accept(cable);
            changed = true;
        }
        return changed;
    }

    private IEnergyStorage getEnergyCap(BlockPos pos, Direction facing) {
        LazyOptional capability;
        if (this.field_145850_b == null) {
            return null;
        }
        TileEntity tileentity = this.field_145850_b.func_175625_s(pos);
        if (tileentity != null && (capability = tileentity.getCapability(CapabilityEnergy.ENERGY, facing)).isPresent()) {
            return (IEnergyStorage)capability.orElseThrow(() -> new NullPointerException("Trying to get null energy capability for block " + tileentity.func_195044_w().func_177230_c().getRegistryName().toString() + " at " + pos));
        }
        return null;
    }

    public int getMaxTransferRate() {
        return this.maxTransferRate;
    }

    public ArrayList<BlockPos> getPositionsOf(HashSet<CableInfo.Connection> connections) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        connections.forEach(connection -> positions.add(connection.blockPos));
        return positions;
    }

    public void setConnection(Direction facing, int i) {
        this.getConnections()[facing.func_176745_a()] = i;
        if (this.getMasterCable() != null) {
            this.getMasterCable().addMachinesFrom(this);
        }
    }

    public int getConnection(Direction direction) {
        return this.getConnections()[direction.func_176745_a()];
    }

    public void rotateConnection(Direction direction) {
        this.rotateConnection(direction.func_176745_a());
    }

    public void rotateConnection(int direction) {
        int next = this.getConnections()[direction] + 1;
        if (next > 3) {
            next = 2;
        }
        this.setConnection(Direction.func_82600_a((int)direction), next);
    }

    public ArrayList<BlockPos> getAllCables() {
        ArrayList<BlockPos> cables = new ArrayList<BlockPos>(this.info().slaves);
        cables.add(this.info().masterPos);
        return cables;
    }

    public void addConsumer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        if (!this.contains(this.info().consumers, connection)) {
            this.info().consumers.add(connection);
            this.removeProducer(connection);
        }
    }

    public void addProducer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        if (!this.contains(this.info().producers, connection)) {
            this.info().producers.add(connection);
            this.removeConsumer(connection);
        }
    }

    public void removeConsumer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        this.remove(this.info().consumers, connection);
    }

    public void removeProducer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        this.remove(this.info().producers, connection);
    }

    public boolean contains(Collection<CableInfo.Connection> connections, CableInfo.Connection newConnection) {
        return connections.stream().anyMatch(connection -> this.equals((CableInfo.Connection)connection, newConnection));
    }

    public void remove(Collection<CableInfo.Connection> connections, CableInfo.Connection newConnection) {
        connections.removeIf(connection -> this.equals((CableInfo.Connection)connection, newConnection));
    }

    public boolean equals(CableInfo.Connection connection, CableInfo.Connection connection2) {
        return connection.blockPos.equals((Object)connection2.blockPos) && connection.direction == connection2.direction;
    }

    public CableInfo info() {
        return this.cableInfo;
    }

    public void setIsMaster(boolean value) {
        this.info().isMaster = value;
        this.info().masterPos = this.func_174877_v();
        this.info().slaves.remove(this.func_174877_v());
    }

    public boolean isMaster() {
        return this.info().isMaster;
    }

    public BlockPos getMasterPos() {
        return this.info().masterPos;
    }

    public HashSet<BlockPos> getSlaves() {
        return this.info().slaves;
    }

    public HashSet<CableInfo.Connection> getConsumers() {
        return this.info().consumers;
    }

    public HashSet<CableInfo.Connection> getProducers() {
        return this.info().producers;
    }

    public HashSet<CableInfo.Connection> getStorages() {
        return this.info().storages;
    }

    public int[] getConnections() {
        return this.info().connections;
    }

    public void clear(boolean keepConnection) {
        this.cableInfo = this.cableInfo.clear(keepConnection);
        this.checkConnections();
    }

    public TestCableTileEntity getMasterCable() {
        return this.getCableTE(this.getMasterPos());
    }

    public TestCableTileEntity getCableTE(BlockPos pos) {
        if (this.field_145850_b == null) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        return tileEntity instanceof TestCableTileEntity ? (TestCableTileEntity)tileEntity : null;
    }
}

