/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.Optional;
import javax.annotation.Nullable;
import net.kaneka.planttech2.container.InfuserContainer;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryFluidTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class InfuserTileEntity
extends EnergyInventoryFluidTileEntity {
    private int fluidInfused = 0;
    private int fluidTotal = 0;
    private Item output = null;
    private RangedWrapper inputs;
    private RangedWrapper outputs;
    private LazyOptional<IItemHandler> inputs_provider;
    private LazyOptional<IItemHandler> outputs_provider;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return InfuserTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return InfuserTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return InfuserTileEntity.this.BIOMASS_CAP.getCurrentStorage();
                }
                case 3: {
                    return InfuserTileEntity.this.BIOMASS_CAP.getMaxStorage();
                }
                case 4: {
                    return InfuserTileEntity.this.fluidInfused;
                }
                case 5: {
                    return InfuserTileEntity.this.fluidTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    InfuserTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    InfuserTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    InfuserTileEntity.this.BIOMASS_CAP.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    InfuserTileEntity.this.BIOMASS_CAP.setMaxStorage(value);
                    break;
                }
                case 4: {
                    InfuserTileEntity.this.fluidInfused = value;
                    break;
                }
                case 5: {
                    InfuserTileEntity.this.fluidTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 6;
        }
    };

    public InfuserTileEntity() {
        super(ModTileEntities.INFUSER_TE, 1000, 8, 5000, 2);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 1);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 1, 2);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() > this.energyPerTick()) {
            InfuserRecipe recipe;
            ItemStack stack1 = this.itemhandler.getStackInSlot(0);
            ItemStack stack2 = this.itemhandler.getStackInSlot(1);
            if (!stack1.func_190926_b() && (recipe = this.getOutputRecipe()) != null) {
                if (recipe.getOutput() == this.output || this.output == null) {
                    if (this.output == null) {
                        this.output = recipe.getOutput();
                        this.fluidTotal = recipe.getBiomass();
                    }
                    int fluidpertick = this.fluidPerTick();
                    if (this.BIOMASS_CAP.getCurrentStorage() >= fluidpertick) {
                        if (this.fluidInfused + fluidpertick < this.fluidTotal) {
                            this.fluidInfused += fluidpertick;
                            this.BIOMASS_CAP.extractBiomass(fluidpertick);
                            this.energystorage.extractEnergy(this.energyPerTick(), false);
                        } else if (stack2.func_190926_b()) {
                            this.itemhandler.setStackInSlot(1, recipe.func_77571_b());
                            this.energystorage.extractEnergy(this.energyPerTick(), false);
                            stack1.func_190918_g(1);
                            this.fluidInfused = 0;
                            this.BIOMASS_CAP.extractBiomass(this.fluidTotal - this.fluidInfused);
                            this.addKnowledge();
                        } else if (stack2.func_77973_b() == recipe.getOutput() && stack2.func_190916_E() < stack2.func_77976_d()) {
                            stack2.func_190917_f(1);
                            this.energystorage.extractEnergy(this.energyPerTick(), false);
                            stack1.func_190918_g(1);
                            this.fluidInfused = 0;
                            this.BIOMASS_CAP.extractBiomass(this.fluidTotal - this.fluidInfused);
                            this.addKnowledge();
                        }
                    }
                } else {
                    this.fluidInfused = 0;
                    this.fluidTotal = recipe.getBiomass();
                    this.output = recipe.getOutput();
                }
            }
        }
        this.doEnergyLoop();
        this.doFluidLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private InfuserRecipe getOutputRecipe() {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.itemhandler);
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.INFUSING, (IInventory)wrapper, this.field_145850_b);
        return recipe.orElse(null);
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(2, TierItem.ItemType.SPEED_UPGRADE) * 4;
    }

    public int fluidPerTick() {
        return 5 + this.getUpgradeTier(2, TierItem.ItemType.SPEED_UPGRADE) * 3;
    }

    @Override
    public String getNameString() {
        return "infuser";
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("tickspassed", this.fluidInfused);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.fluidInfused = compound.func_74762_e("tickspassed");
        super.func_230337_a_(state, compound);
    }

    @Override
    protected int getFluidInSlot() {
        return 3;
    }

    @Override
    protected int getFluidOutSlot() {
        return 4;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new InfuserContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 5;
    }

    @Override
    public int getEnergyOutSlot() {
        return 6;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 7;
    }

    @Override
    public int getKnowledgePerAction() {
        return 150;
    }
}

