/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.Optional;
import javax.annotation.Nullable;
import net.kaneka.planttech2.container.MegaFurnaceContainer;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MegaFurnaceTileEntity
extends EnergyInventoryTileEntity {
    public int[] ticksPassed = new int[6];
    boolean isSmelting;
    protected ItemStackHandler dummyitemhandler = new ItemStackHandler(1);
    private RangedWrapper inputs;
    private RangedWrapper outputs;
    private LazyOptional<IItemHandler> inputs_provider;
    private LazyOptional<IItemHandler> outputs_provider;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return MegaFurnaceTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return MegaFurnaceTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return MegaFurnaceTileEntity.this.ticksPassed[0];
                }
                case 3: {
                    return MegaFurnaceTileEntity.this.ticksPassed[1];
                }
                case 4: {
                    return MegaFurnaceTileEntity.this.ticksPassed[2];
                }
                case 5: {
                    return MegaFurnaceTileEntity.this.ticksPassed[3];
                }
                case 6: {
                    return MegaFurnaceTileEntity.this.ticksPassed[4];
                }
                case 7: {
                    return MegaFurnaceTileEntity.this.ticksPassed[5];
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    MegaFurnaceTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    MegaFurnaceTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    MegaFurnaceTileEntity.this.ticksPassed[0] = value;
                    break;
                }
                case 3: {
                    MegaFurnaceTileEntity.this.ticksPassed[1] = value;
                    break;
                }
                case 4: {
                    MegaFurnaceTileEntity.this.ticksPassed[2] = value;
                    break;
                }
                case 5: {
                    MegaFurnaceTileEntity.this.ticksPassed[3] = value;
                    break;
                }
                case 6: {
                    MegaFurnaceTileEntity.this.ticksPassed[4] = value;
                    break;
                }
                case 7: {
                    MegaFurnaceTileEntity.this.ticksPassed[5] = value;
                }
            }
        }

        public int func_221478_a() {
            return 8;
        }
    };

    public MegaFurnaceTileEntity() {
        super(ModTileEntities.MEGAFURNACE_TE, 10000, 16, 3);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 6);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 6, 12);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        this.isSmelting = false;
        for (int i = 0; i < 6; ++i) {
            if (this.energystorage.getEnergyStored() > this.getEnergyPerTickPerItem()) {
                if (this.canSmelt(i)) {
                    this.isSmelting = true;
                    int n = i;
                    this.ticksPassed[n] = this.ticksPassed[n] + 1;
                    if (this.ticksPassed[i] < this.getTicksPerItem()) continue;
                    this.smeltItem(i);
                    this.ticksPassed[i] = 0;
                    this.addKnowledge();
                    continue;
                }
                if (this.ticksPassed[i] <= 0) continue;
                this.ticksPassed[i] = 0;
                continue;
            }
            if (this.canSmelt(i) || this.ticksPassed[i] <= 0) break;
            this.ticksPassed[i] = 0;
            break;
        }
        if (this.isSmelting) {
            this.energystorage.extractEnergy(this.getEnergyPerTickPerItem(), false);
        }
        this.doEnergyLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private boolean canSmelt(int slot) {
        ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack output = this.getOutput(slot);
        if (output.func_190926_b()) {
            return false;
        }
        ItemStack outputslot = this.itemhandler.getStackInSlot(slot + 6);
        if (outputslot.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(outputslot)) {
            return false;
        }
        if (outputslot.func_190916_E() + output.func_190916_E() <= 64 && outputslot.func_190916_E() + output.func_190916_E() <= outputslot.func_77976_d()) {
            return true;
        }
        return outputslot.func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    public ItemStack getOutput(int slot) {
        this.dummyitemhandler.setStackInSlot(0, this.itemhandler.getStackInSlot(slot));
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.dummyitemhandler);
        Optional recipeopt = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)wrapper, this.field_145850_b);
        FurnaceRecipe recipe = recipeopt.orElse(null);
        if (recipe != null) {
            return recipe.func_77571_b();
        }
        return ItemStack.field_190927_a;
    }

    public void smeltItem(int slot) {
        if (this.canSmelt(slot)) {
            ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
            ItemStack itemstack1 = this.getOutput(slot);
            ItemStack itemstack2 = this.itemhandler.getStackInSlot(slot + 6);
            if (itemstack2.func_190926_b()) {
                this.itemhandler.setStackInSlot(slot + 6, itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            itemstack.func_190918_g(1);
        }
    }

    public int getEnergyPerTickPerItem() {
        return 4 + this.getUpgradeTier(12, TierItem.ItemType.SPEED_UPGRADE) * 4;
    }

    public int getTicksPerItem() {
        return 200 - this.getUpgradeTier(12, TierItem.ItemType.SPEED_UPGRADE) * 35;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        for (int i = 0; i < 6; ++i) {
            compound.func_74768_a("cooktime_" + i, this.ticksPassed[i]);
        }
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        for (int i = 0; i < 6; ++i) {
            this.ticksPassed[i] = compound.func_74762_e("cooktime_" + i);
        }
        super.func_230337_a_(state, compound);
    }

    @Override
    public String getNameString() {
        return "megafurnace";
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new MegaFurnaceContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 13;
    }

    @Override
    public int getEnergyOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 15;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }
}

