/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import javax.annotation.Nullable;
import net.kaneka.planttech2.container.SeedSqueezerContainer;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryFluidTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class SeedSqueezerTileEntity
extends EnergyInventoryFluidTileEntity {
    public int ticksPassed = 0;
    private RangedWrapper inputs;
    private LazyOptional<IItemHandler> inputs_provider;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return SeedSqueezerTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return SeedSqueezerTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return SeedSqueezerTileEntity.this.BIOMASS_CAP.getCurrentStorage();
                }
                case 3: {
                    return SeedSqueezerTileEntity.this.BIOMASS_CAP.getMaxStorage();
                }
                case 4: {
                    return SeedSqueezerTileEntity.this.ticksPassed;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    SeedSqueezerTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    SeedSqueezerTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    SeedSqueezerTileEntity.this.BIOMASS_CAP.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    SeedSqueezerTileEntity.this.BIOMASS_CAP.setMaxStorage(value);
                    break;
                }
                case 4: {
                    SeedSqueezerTileEntity.this.ticksPassed = value;
                }
            }
        }

        public int func_221478_a() {
            return 5;
        }
    };

    public SeedSqueezerTileEntity() {
        super(ModTileEntities.SEEDSQUEEZER_TE, 10000, 16, 5000, 0);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 9);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            if (this.itemhandler.getStackInSlot(9).func_190926_b() && (i = this.getSqueezeableItem()) != 100) {
                ItemStack stack = this.itemhandler.getStackInSlot(i);
                ItemStack stack2 = stack.func_77946_l();
                stack2.func_190920_e(1);
                this.itemhandler.setStackInSlot(9, stack2);
                stack.func_190918_g(1);
            }
            if (!this.itemhandler.getStackInSlot(9).func_190926_b()) {
                ItemStack stack = this.itemhandler.getStackInSlot(9);
                if (stack.func_190916_E() == 1 && stack.func_77973_b() instanceof CropSeedItem) {
                    this.ticksPassed += this.getUpgradeTier(10, TierItem.ItemType.SPEED_UPGRADE) + 1;
                    if (this.ticksPassed >= this.getTicksPerItem()) {
                        this.squeezeItem();
                        this.addKnowledge();
                        this.BIOMASS_CAP.changeCurrentStorage(10);
                        this.ticksPassed = 0;
                    }
                } else if (stack.func_190916_E() > 0) {
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), stack));
                        this.itemhandler.setStackInSlot(9, ItemStack.field_190927_a);
                    }
                } else if (this.ticksPassed > 0) {
                    this.ticksPassed = 0;
                }
            }
        }
        this.doEnergyLoop();
        this.doFluidLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private int getSqueezeableItem() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof CropSeedItem)) continue;
            return i;
        }
        return 100;
    }

    public void squeezeItem() {
        this.energystorage.receiveEnergy(this.getEnergyPerItem(), false);
        this.itemhandler.setStackInSlot(9, ItemStack.field_190927_a);
    }

    public int getTicksPerItem() {
        return 200;
    }

    public int getEnergyPerItem() {
        CompoundNBT nbt;
        ItemStack stack = this.itemhandler.getStackInSlot(9);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof CropSeedItem && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("energyvalue")) {
            return nbt.func_74762_e("energyvalue") * 20;
        }
        return 20;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("cooktime", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.ticksPassed = compound.func_74762_e("cooktime");
        super.func_230337_a_(state, compound);
    }

    @Override
    public String getNameString() {
        return "seedsqueezer";
    }

    @Override
    public int getFluidInSlot() {
        return 11;
    }

    @Override
    public int getFluidOutSlot() {
        return 12;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new SeedSqueezerContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 13;
    }

    @Override
    public int getEnergyOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 15;
    }

    @Override
    public int getKnowledgePerAction() {
        return 2;
    }
}

