/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    protected BioEnergyStorage energystorage;
    private LazyOptional<IEnergyStorage> energyCap;
    public String customname;

    public EnergyTileEntity(TileEntityType<?> type, int energyStorage) {
        super(type);
        this.energystorage = new BioEnergyStorage(energyStorage);
        this.energyCap = LazyOptional.of(() -> this.energystorage);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.doUpdate();
        }
    }

    public void doUpdate() {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("energy", (INBT)this.energystorage.serializeNBT());
        super.func_189515_b(compound);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.energystorage.deserializeNBT(compound.func_74775_l("energy"));
    }

    public String getNameString() {
        return "default";
    }

    public int getEnergyStored() {
        return this.energystorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energystorage.getMaxEnergyStored();
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void onSlotContentChanged() {
    }

    public abstract IIntArray getIntArray();

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container." + this.getNameString());
    }
}

