/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class ThermoPlantRecipe
extends PneumaticCraftRecipe {
    protected ThermoPlantRecipe(ResourceLocation id) {
        super(id);
    }

    public abstract boolean matches(FluidStack var1, ItemStack var2);

    public abstract TemperatureRange getOperatingTemperature();

    public abstract float getRequiredPressure();

    public double heatUsed(double ambientTemperature) {
        TemperatureRange range = this.getOperatingTemperature();
        if (range.isAny()) {
            return 0.0;
        }
        double used = (double)range.getMin() > ambientTemperature ? ((double)range.getMin() - ambientTemperature) / 10.0 : ((double)range.getMax() < ambientTemperature ? (ambientTemperature - (double)range.getMax()) / 10.0 : (this.isExothermic() ? ((double)range.getMax() - ambientTemperature) / 10.0 : (ambientTemperature - (double)range.getMin()) / 10.0));
        return this.isExothermic() ? -used : used;
    }

    public int airUsed() {
        return (int)(50.0f * this.getRequiredPressure());
    }

    public abstract Ingredient getInputItem();

    public abstract FluidIngredient getInputFluid();

    public abstract FluidStack getOutputFluid();

    public abstract ItemStack getOutputItem();

    public abstract boolean isExothermic();
}

