/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.common.inventory.ContainerAirCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAirCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiAirCompressor
extends GuiPneumaticContainerBase<ContainerAirCompressor, TileEntityAirCompressor> {
    public GuiAirCompressor(ContainerAirCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AIR_COMPRESSOR;
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i1 = ((TileEntityAirCompressor)this.te).getBurnTimeRemainingScaled(12);
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        if (((TileEntityAirCompressor)this.te).burnTime >= ((TileEntityAirCompressor)this.te).curFuelUsage) {
            this.blit(xStart + this.getFuelSlotXOffset(), yStart + 38 + 12 - i1, 176, 12 - i1, 14, i1 + 2);
        }
    }

    protected int getFuelSlotXOffset() {
        return 80;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.maxProduction", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityAirCompressor)this.te).airPerTick, 2)}));
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityAirCompressor)this.te).burnTime <= ((TileEntityAirCompressor)this.te).curFuelUsage && !FurnaceTileEntity.func_213991_b((ItemStack)((TileEntityAirCompressor)this.te).getPrimaryInventory().getStackInSlot(0))) {
            textList.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.airCompressor.noFuel", (Object[])new Object[0]));
        }
        if (((TileEntityAirCompressor)this.te).hasNoConnectedAirHandlers()) {
            textList.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.airLeak", (Object[])new Object[0]));
        }
    }

    @Override
    protected String upgradeCategory() {
        return "air_compressor";
    }
}

