/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiInventorySearcher;
import me.desht.pneumaticcraft.client.gui.GuiItemSearcher;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsLiquidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadronAddTrade;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class GuiAmadronAddTrade
extends GuiPneumaticContainerBase<ContainerAmadronAddTrade, TileEntityBase> {
    private GuiItemSearcher searchGui;
    private GuiInventorySearcher invSearchGui;
    private GuiInventorySearcher gpsSearchGui;
    private GuiLogisticsLiquidFilter fluidGui;
    private int settingSlot;
    private final WidgetFluidFilter[] fluidFilters = new WidgetFluidFilter[2];
    private final WidgetTextFieldNumber[] amountFields = new WidgetTextFieldNumber[2];
    private final BlockPos[] positions = new BlockPos[2];
    private Button addButton;

    public GuiAmadronAddTrade(ContainerAmadronAddTrade container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_146999_f = 183;
        this.field_147000_g = 202;
    }

    @Override
    public void init() {
        super.init();
        if (this.searchGui != null) {
            this.setStack(this.settingSlot, this.searchGui.getSearchStack());
        } else if (this.invSearchGui != null) {
            this.setStack(this.settingSlot, this.invSearchGui.getSearchStack());
        } else if (this.fluidGui != null) {
            this.setFluid(this.settingSlot, this.fluidGui.getFilter());
        } else if (this.gpsSearchGui != null) {
            this.positions[this.settingSlot] = this.gpsSearchGui.getSearchStack().func_190926_b() ? null : ItemGPSTool.getGPSLocation(this.gpsSearchGui.getSearchStack());
        }
        this.searchGui = null;
        this.fluidGui = null;
        this.invSearchGui = null;
        this.gpsSearchGui = null;
        this.initSide(0);
        this.initSide(1);
        this.setFocused((IGuiEventListener)this.amountFields[0]);
        this.addButton = new Button(this.field_147003_i + 50, this.field_147009_r + 171, 85, 20, "Add Trade", b -> this.addTrade());
        this.addButton((Widget)this.addButton);
        this.addJeiFilterInfoTab();
    }

    public void setStack(int slot, ItemStack stack) {
        this.fluidFilters[slot].setFluid(Fluids.field_204541_a);
        ((ContainerAmadronAddTrade)this.field_147002_h).setStack(slot, stack);
    }

    public void setFluid(int slot, Fluid stack) {
        ((ContainerAmadronAddTrade)this.field_147002_h).setStack(slot, ItemStack.field_190927_a);
        this.fluidFilters[slot].setFluid(stack);
    }

    private void initSide(int slot) {
        int xOffset = slot == 0 ? 0 : 89;
        String s = slot == 0 ? "selling" : "buying";
        this.addButton(new WidgetLabel(this.field_147003_i + 48 + xOffset, this.field_147009_r + 7, I18n.func_135052_a((String)("pneumaticcraft.gui.amadron.addTrade." + s), (Object[])new Object[0]), -1).setAlignment(WidgetLabel.Alignment.CENTRE));
        this.addButton((Widget)new Button(this.field_147003_i + 4 + xOffset, this.field_147009_r + 20, 85, 20, "Search item...", b -> this.openItemSearchGui(slot)));
        this.addButton((Widget)new Button(this.field_147003_i + 4 + xOffset, this.field_147009_r + 42, 85, 20, "Search inv...", b -> this.openInventorySearchGui(slot)));
        this.addButton((Widget)new Button(this.field_147003_i + 4 + xOffset, this.field_147009_r + 64, 85, 20, "Search fluid...", b -> this.openFluidSearchGui(slot)));
        Fluid prev = this.fluidFilters[slot] != null ? this.fluidFilters[slot].getFluid() : Fluids.field_204541_a;
        this.fluidFilters[slot] = new WidgetFluidFilter(this.field_147003_i + 37 + xOffset, this.field_147009_r + 90, prev);
        this.addButton(this.fluidFilters[slot]);
        String tip = slot == 0 ? "pneumaticcraft.gui.amadron.button.selectSellingBlock.tooltip" : "pneumaticcraft.gui.amadron.button.selectPaymentBlock.tooltip";
        this.addButton((Widget)new WidgetButtonExtended(this.field_147003_i + 10 + xOffset, this.field_147009_r + 115, 20, 20, "", b -> this.openGPSGui(slot)).setTooltipText(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)tip, (Object[])new Object[0]), 40)).setRenderStacks(new ItemStack((IItemProvider)ModItems.GPS_TOOL.get())));
        this.font.getClass();
        this.amountFields[slot] = new WidgetTextFieldNumber(this.font, this.field_147003_i + 22 + xOffset, this.field_147009_r + 145, 40, 9).setValue(this.amountFields[slot] != null ? (double)this.amountFields[slot].getValue() : 1.0);
        this.addButton((Widget)this.amountFields[slot]);
        this.addButton(new WidgetLabel(this.field_147003_i + 65 + xOffset, this.field_147009_r + 145, this.fluidFilters[slot].getFluid() != Fluids.field_204541_a ? "mB" : "", -1));
        GlobalPos p = this.getPosition(slot);
        if (p != null && p.func_218177_a() == this.minecraft.field_71441_e.func_201675_m().func_186058_p()) {
            BlockState state = this.minecraft.field_71441_e.func_180495_p(p.func_218180_b());
            String name = new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()).func_200301_q().func_150254_d();
            ((WidgetLabel)this.addButton(new WidgetLabel(this.field_147003_i + 32 + xOffset, this.field_147009_r + 118, name, -1))).setScale(0.5f);
            ((WidgetLabel)this.addButton(new WidgetLabel(this.field_147003_i + 32 + xOffset, this.field_147009_r + 124, " @ " + this.posToString(p.func_218180_b()), -1))).setScale(0.5f);
        }
        if (this.positions[slot] == null) {
            ((WidgetLabel)this.addButton(new WidgetLabel(this.field_147003_i + 32 + xOffset, this.field_147009_r + 130, "[Default]", -4144960))).setScale(0.5f);
        }
    }

    private String posToString(BlockPos pos) {
        return pos == null ? "[Default]" : PneumaticCraftUtils.posToString(pos);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    @Override
    public void onClose() {
        NetworkHandler.sendToServer(new PacketGuiButton("showAmadron"));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
        } else if (keyCode == 258) {
            WidgetTextFieldNumber amountIn = this.amountFields[0];
            WidgetTextFieldNumber amountOut = this.amountFields[1];
            if (amountIn.isFocused()) {
                amountIn.func_146190_e(amountIn.func_146198_h());
                amountIn.func_146195_b(false);
                this.setFocused((IGuiEventListener)amountOut);
                amountOut.func_146190_e(0);
                amountOut.func_146199_i(amountOut.func_146179_b().length());
            } else if (amountOut.isFocused()) {
                amountOut.func_146190_e(amountOut.func_146198_h());
                amountOut.func_146195_b(false);
                this.setFocused((IGuiEventListener)amountIn);
                amountIn.func_146190_e(0);
                amountIn.func_146199_i(amountIn.func_146179_b().length());
            }
        }
        if (this.getFocused() instanceof WidgetTextField) {
            WidgetTextField tf = (WidgetTextField)this.getFocused();
            return tf.keyPressed(keyCode, scanCode, modifiers) || tf.func_212955_f() || super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected int getBackgroundTint() {
        return -16347604;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON_ADD_TRADE;
    }

    private void openItemSearchGui(int slot) {
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.ITEM_SEARCHER.get()), (ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.amadron.addTrade.itemSearch", new Object[0]));
        if (this.minecraft.field_71462_r instanceof GuiItemSearcher) {
            this.settingSlot = slot;
            this.searchGui = (GuiItemSearcher)this.minecraft.field_71462_r;
            this.searchGui.setSearchStack(((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot));
        }
    }

    private void openInventorySearchGui(int slot) {
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.INVENTORY_SEARCHER.get()), (ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.amadron.addTrade.invSearch", new Object[0]));
        if (this.minecraft.field_71462_r instanceof GuiInventorySearcher) {
            this.settingSlot = slot;
            this.invSearchGui = (GuiInventorySearcher)this.minecraft.field_71462_r;
            this.invSearchGui.setSearchStack(((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot));
        }
    }

    private void openFluidSearchGui(int slot) {
        this.settingSlot = slot;
        this.fluidGui = new GuiLogisticsLiquidFilter((Screen)this);
        this.fluidGui.setFilter(this.fluidFilters[slot].getFluid());
        this.minecraft.func_147108_a((Screen)this.fluidGui);
    }

    private void openGPSGui(int slot) {
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.INVENTORY_SEARCHER.get()), (ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.amadron.addTrade.gpsSearch", new Object[0]));
        if (this.minecraft.field_71462_r instanceof GuiInventorySearcher) {
            this.gpsSearchGui = (GuiInventorySearcher)this.minecraft.field_71462_r;
            this.gpsSearchGui.setStackPredicate(itemStack -> itemStack.func_77973_b() instanceof IPositionProvider);
            this.settingSlot = slot;
            ItemStack gps = new ItemStack((IItemProvider)ModItems.GPS_TOOL.get());
            GlobalPos gPos = this.getPosition(slot);
            if (gPos != null) {
                ItemGPSTool.setGPSLocation(gps, gPos.func_218180_b());
            }
            this.gpsSearchGui.setSearchStack(ItemGPSTool.getGPSLocation(gps) != null ? gps : ItemStack.field_190927_a);
        }
    }

    private void addTrade() {
        AmadronTradeResource[] resources = new AmadronTradeResource[2];
        for (int slot = 0; slot < resources.length; ++slot) {
            resources[slot] = !((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot).func_190926_b() ? AmadronTradeResource.of(ItemHandlerHelper.copyStackWithSize((ItemStack)((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot), (int)this.amountFields[slot].getValue())) : AmadronTradeResource.of(new FluidStack(this.fluidFilters[slot].getFluid(), this.amountFields[slot].getValue()));
        }
        String id = this.minecraft.field_71439_g.func_200200_C_().func_150261_e().toLowerCase() + "_" + System.currentTimeMillis() / 1000L;
        AmadronPlayerOffer trade = new AmadronPlayerOffer(PneumaticCraftUtils.RL(id), resources[1], resources[0], (PlayerEntity)this.minecraft.field_71439_g).setProvidingPosition(this.getPosition(0)).setReturningPosition(this.getPosition(1));
        NetworkHandler.sendToServer(new PacketAmadronTradeAddCustom(trade));
        this.minecraft.field_71439_g.func_71053_j();
    }

    private GlobalPos getPosition(int slot) {
        if (this.positions[slot] != null) {
            return GlobalPos.func_218179_a((DimensionType)this.field_213127_e.field_70458_d.field_70170_p.func_201675_m().func_186058_p(), (BlockPos)this.positions[slot]);
        }
        if (!((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot).func_190926_b()) {
            return ItemAmadronTablet.getItemProvidingLocation(this.field_213127_e.field_70458_d.func_184614_ca());
        }
        if (this.fluidFilters[slot].getFluid() != Fluids.field_204541_a) {
            return ItemAmadronTablet.getFluidProvidingLocation(this.field_213127_e.field_70458_d.func_184614_ca());
        }
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        GlobalPos inPos = this.getPosition(0);
        GlobalPos outPos = this.getPosition(1);
        this.addButton.active = !(this.amountFields[0].getValue() <= 0 || this.amountFields[1].getValue() <= 0 || this.fluidFilters[0].getFluid() == Fluids.field_204541_a && ((ContainerAmadronAddTrade)this.field_147002_h).getInputStack().func_190926_b() || this.fluidFilters[1].getFluid() == Fluids.field_204541_a && ((ContainerAmadronAddTrade)this.field_147002_h).getOutputStack().func_190926_b() || inPos == null || outPos == null);
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        if (this.getPosition(0) == null || this.getPosition(1) == null) {
            curInfo.add("pneumaticcraft.gui.amadron.addTrade.problems.noSellingOrPayingBlock");
        }
        super.addProblems(curInfo);
    }
}

