/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerElectrostaticCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElectrostaticCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiElectrostaticCompressor
extends GuiPneumaticContainerBase<ContainerElectrostaticCompressor, TileEntityElectrostaticCompressor> {
    private int connectedCompressors = 1;
    private int ticksExisted;
    private WidgetAnimatedStat electrostaticStat;

    public GuiElectrostaticCompressor(ContainerElectrostaticCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.electrostaticStat = this.addAnimatedStat("pneumaticcraft.gui.tab.info.electrostaticCompressor.title", new ItemStack((IItemProvider)ModBlocks.ELECTROSTATIC_COMPRESSOR.get()), -14638849, false);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected void addWarnings(List<String> textList) {
        super.addWarnings(textList);
        int grounding = 10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath;
        int generated = 200000 / this.connectedCompressors;
        if (grounding < generated) {
            textList.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.electrostatic.notEnoughGrounding", (Object[])new Object[]{grounding, generated}));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksExisted % 20 == 0) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            positions.add(((TileEntityElectrostaticCompressor)this.te).func_174877_v());
            ((TileEntityElectrostaticCompressor)this.te).getElectrostaticGrid(positions, ((TileEntityElectrostaticCompressor)this.te).func_145831_w(), ((TileEntityElectrostaticCompressor)this.te).func_174877_v(), null);
            this.connectedCompressors = 0;
            for (BlockPos coord : positions) {
                if (((TileEntityElectrostaticCompressor)this.te).func_145831_w().func_180495_p(coord).func_177230_c() != ModBlocks.ELECTROSTATIC_COMPRESSOR.get()) continue;
                ++this.connectedCompressors;
            }
        }
        ++this.ticksExisted;
        String col = TextFormatting.BLACK.toString();
        ArrayList<String> info = new ArrayList<String>();
        info.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.electrostatic.generating", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(200000.0f / (float)this.connectedCompressors, 1)}));
        info.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.electrostatic.connected", (Object[])new Object[]{this.connectedCompressors}));
        info.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.electrostatic.maxRedirection", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath, 1)}));
        info.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.electrostatic.lightningRod", (Object[])new Object[]{((TileEntityElectrostaticCompressor)this.te).ironBarsAbove}));
        info.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.electrostatic.strikeTime", (Object[])new Object[]{PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntityElectrostaticCompressor)this.te).getStrikeChance(), false)}));
        info.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.electrostatic.strikeTime.optimal", (Object[])new Object[0]));
        this.electrostaticStat.setText(info);
    }
}

