/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerFluxCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityFluxCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GuiFluxCompressor
extends GuiPneumaticContainerBase<ContainerFluxCompressor, TileEntityFluxCompressor> {
    private WidgetAnimatedStat inputStat;
    private WidgetTemperature tempWidget;

    public GuiFluxCompressor(ContainerFluxCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.inputStat = this.addAnimatedStat("Input", Textures.GUI_BUILDCRAFT_ENERGY, -11184811, false);
        ((TileEntityFluxCompressor)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> {
            WidgetEnergy cfr_ignored_0 = (WidgetEnergy)this.addButton(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, (IEnergyStorage)storage));
        });
        this.tempWidget = new WidgetTemperature(this.field_147003_i + 97, this.field_147009_r + 20, TemperatureRange.of(223, 673), 273, 50).setOperatingRange(TemperatureRange.of(323, 625)).setShowOperatingRange(false);
        this.addButton(this.tempWidget);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected PointXY getGaugeLocation() {
        return super.getGaugeLocation().add(10, 0);
    }

    @Override
    public void tick() {
        super.tick();
        this.inputStat.setText(this.getOutputStat());
        ((TileEntityFluxCompressor)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(h -> this.tempWidget.setTemperature(h.getTemperatureAsInt()));
        this.tempWidget.autoScaleForTemperature();
    }

    private List<String> getOutputStat() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.status.fluxCompressor.maxEnergyUsage", (Object[])new Object[0]));
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() + " FE/t");
        textList.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.status.fluxCompressor.maxInputRate", (Object[])new Object[0]));
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() * 2 + " FE/t");
        textList.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.status.fluxCompressor.storedEnergy", (Object[])new Object[0]));
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityFluxCompressor)this.te).getInfoEnergyStored() + " FE");
        return textList;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.maxProduction", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityFluxCompressor)this.te).getAirRate(), 2)}));
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityFluxCompressor)this.te).getInfoEnergyPerTick() > ((TileEntityFluxCompressor)this.te).getInfoEnergyStored()) {
            textList.add("pneumaticcraft.gui.tab.problems.fluxCompressor.noRF");
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        if (((TileEntityFluxCompressor)this.te).getHeatEfficiency() < 100) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.advancedAirCompressor.efficiency", (Object[])new Object[]{((TileEntityFluxCompressor)this.te).getHeatEfficiency() + "%%"}));
        }
    }
}

