/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class GuiGPSTool
extends GuiPneumaticScreenBase {
    private static final int TEXTFIELD_WIDTH = 40;
    protected final WidgetTextFieldNumber[] textFields = new WidgetTextFieldNumber[3];
    protected WidgetTextField variableField;
    protected final Hand hand;
    private final BlockPos oldGPSLoc;
    private String oldVarName;

    protected GuiGPSTool(ITextComponent title, Hand hand, BlockPos gpsLoc, String oldVarName) {
        super(title);
        this.hand = hand;
        this.oldGPSLoc = gpsLoc;
        this.oldVarName = oldVarName;
    }

    public static void showGUI(ItemStack stack, Hand handIn, BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiGPSTool(stack.func_200301_q(), handIn, pos != null ? pos : BlockPos.field_177992_a, ItemGPSTool.getVariable(stack)));
    }

    @Override
    public void init() {
        int i;
        super.init();
        int[] oldText = new int[3];
        if (this.textFields[0] == null) {
            oldText[0] = this.oldGPSLoc.func_177958_n();
            oldText[1] = this.oldGPSLoc.func_177956_o();
            oldText[2] = this.oldGPSLoc.func_177952_p();
        } else {
            for (int i2 = 0; i2 < 3; ++i2) {
                oldText[i2] = this.textFields[i2].getValue();
            }
        }
        int xMiddle = this.width / 2;
        int yMiddle = this.height / 2;
        for (i = 0; i < 3; ++i) {
            this.font.getClass();
            this.textFields[i] = new WidgetTextFieldNumber(this.font, xMiddle - 20, yMiddle - 15 + i * 22, 40, 9).setValue(oldText[i]);
            if (i == 1) {
                this.textFields[i].minValue = 0;
                this.textFields[i].maxValue = 255;
            }
            this.addButton((Widget)this.textFields[i]);
        }
        for (i = 0; i < 3; ++i) {
            int idx = i;
            this.addButton((Widget)new Button(xMiddle - 49 - 20, yMiddle - 20 + i * 22, 22, 20, "-10", b -> this.updateTextField(idx, -10)));
            this.addButton((Widget)new Button(xMiddle - 25 - 20, yMiddle - 20 + i * 22, 22, 20, "-1", b -> this.updateTextField(idx, -1)));
            this.addButton((Widget)new Button(xMiddle + 3 + 20, yMiddle - 20 + i * 22, 22, 20, "+1", b -> this.updateTextField(idx, 1)));
            this.addButton((Widget)new Button(xMiddle + 27 + 20, yMiddle - 20 + i * 22, 22, 20, "+10", b -> this.updateTextField(idx, 10)));
        }
        if (this.variableField != null) {
            this.oldVarName = this.variableField.func_146179_b();
        }
        this.font.getClass();
        this.variableField = new WidgetTextField(this.font, xMiddle - 50, yMiddle + 60, 100, 9);
        this.variableField.func_146180_a(this.oldVarName);
        this.addButton((Widget)this.variableField);
        String var = I18n.func_135052_a((String)"pneumaticcraft.gui.progWidget.coordinate.variable", (Object[])new Object[0]) + " #";
        this.addButton(new WidgetLabel(xMiddle - 62 - this.font.func_78256_a(var), yMiddle + 61, var, 0xC0C0C0));
    }

    private void updateTextField(int idx, int amount) {
        this.textFields[idx].setValue(this.textFields[idx].getValue() + amount);
    }

    @Override
    public void render(int par1, int par2, float par3) {
        this.renderBackground();
        super.render(par1, par2, par3);
        int xMiddle = this.width / 2;
        int yMiddle = this.height / 2;
        int stringX = xMiddle - 60 - 20;
        this.drawCenteredString(this.font, this.getTitle().func_150254_d(), xMiddle, yMiddle - 58, -1);
        this.font.getClass();
        this.drawString(this.font, "X:", stringX, yMiddle - 10 - 9 / 2, -1);
        this.font.getClass();
        this.drawString(this.font, "Y:", stringX, yMiddle + 4 + 9 / 2, -1);
        this.font.getClass();
        this.drawString(this.font, "Z:", stringX, yMiddle + 34 - 9 / 2, -1);
    }

    public void onClose() {
        this.syncToServer();
        super.onClose();
    }

    protected void syncToServer() {
        BlockPos newPos = new BlockPos(this.textFields[0].getValue(), this.textFields[1].getValue(), this.textFields[2].getValue());
        NetworkHandler.sendToServer(new PacketChangeGPSToolCoordinate(newPos.equals((Object)this.oldGPSLoc) ? new BlockPos(-1, -1, -1) : newPos, this.hand, this.variableField.func_146179_b(), this.getIndex()));
    }

    protected int getIndex() {
        return 0;
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }
}

