/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.fuel.IFuelRegistry;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerLiquidCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityLiquidCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.StringUtils;

public class GuiLiquidCompressor
extends GuiPneumaticContainerBase<ContainerLiquidCompressor, TileEntityLiquidCompressor> {
    public GuiLiquidCompressor(ContainerLiquidCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new WidgetTank(this.field_147003_i + this.getFluidOffset(), this.field_147009_r + 15, (IFluidTank)((TileEntityLiquidCompressor)this.te).getTank()));
        WidgetAnimatedStat stat = this.addAnimatedStat("pneumaticcraft.gui.tab.liquidCompressor.fuel", new ItemStack((IItemProvider)ModItems.LPG_BUCKET.get()), -4176896, true);
        stat.setTextWithoutCuttingString(this.getAllFuels());
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.maxProduction", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityLiquidCompressor)this.te).airPerTick, 2)}));
    }

    protected int getFluidOffset() {
        return 86;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -2);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        return new PointXY(xStart + this.field_146999_f * 3 / 4 + 5, yStart + this.field_147000_g / 4 + 4);
    }

    @Override
    protected String upgradeCategory() {
        return "liquid_compressor";
    }

    private List<String> getAllFuels() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.UNDERLINE + "mL/mB | Fluid (x burn rate)");
        IFuelRegistry api = PneumaticRegistry.getInstance().getFuelRegistry();
        ArrayList<Fluid> fluids = new ArrayList<Fluid>(api.registeredFuels());
        fluids.sort((o1, o2) -> Integer.compare(api.getFuelValue((Fluid)o2), api.getFuelValue((Fluid)o1)));
        int w = this.font.func_78256_a(".");
        for (Fluid fluid : fluids) {
            String value = String.format("%4d", api.getFuelValue(fluid) / 1000);
            int nSpc = (32 - this.font.func_78256_a(value)) / w;
            value = value + StringUtils.repeat((char)'.', (int)nSpc);
            FluidStack stack = new FluidStack(fluid, 1);
            float mul = api.getBurnRateMultiplier(fluid);
            if (mul == 1.0f) {
                text.add(value + "| " + StringUtils.abbreviate((String)stack.getDisplayName().func_150254_d(), (int)25));
                continue;
            }
            text.add(value + "| " + StringUtils.abbreviate((String)stack.getDisplayName().func_150254_d(), (int)20) + " (x" + PneumaticCraftUtils.roundNumberTo(mul, 2) + ")");
        }
        return text;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_COMPRESSOR;
    }

    @Override
    public void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (((TileEntityLiquidCompressor)this.te).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            ((TileEntityLiquidCompressor)this.te).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                if (!((TileEntityLiquidCompressor)this.te).isProducing && fluidHandler.getFluidInTank(0).isEmpty()) {
                    curInfo.add("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel");
                }
            });
        } else {
            curInfo.add("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel");
        }
    }
}

