/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.base.CaseFormat;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.JsonToNBTConverter;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import me.desht.pneumaticcraft.common.util.NBTToJsonConverter;
import me.desht.pneumaticcraft.common.util.PastebinHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiPastebin
extends GuiPneumaticScreenBase {
    private WidgetTextField usernameBox;
    private WidgetTextField passwordBox;
    private WidgetTextField pastebinBox;
    private WidgetCheckBox prettyCB;
    private final CompoundNBT pastingNBT;
    private final Screen parentScreen;
    private String statusMessage = "";
    private String lastMessage = "";
    private int messageTimer;
    private EnumState state = EnumState.NONE;
    CompoundNBT outputTag;
    boolean shouldMerge;

    GuiPastebin(Screen parentScreen, CompoundNBT tag) {
        super((ITextComponent)new StringTextComponent("Pastebin"));
        this.xSize = 183;
        this.ySize = 202;
        this.pastingNBT = tag;
        this.parentScreen = parentScreen;
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
    }

    @Override
    public void init() {
        super.init();
        if (!PastebinHandler.isLoggedIn()) {
            this.usernameBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 30, 80, 10);
            this.addButton((Widget)this.usernameBox);
            this.passwordBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 56, 80, 10).setAsPasswordBox();
            this.addButton((Widget)this.passwordBox);
            WidgetButtonExtended loginButton = new WidgetButtonExtended(this.guiLeft + 100, this.guiTop + 30, 60, 20, I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.button.login", (Object[])new Object[0]), b -> this.login());
            loginButton.setTooltipText("Pastebin login is optional");
            this.addButton((Widget)loginButton);
            this.addLabel(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.username", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 20);
            this.addLabel(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.password", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 46);
        } else {
            WidgetButtonExtended logoutButton = new WidgetButtonExtended(this.guiLeft + 60, this.guiTop + 30, 60, 20, I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.button.logout", (Object[])new Object[0]), b -> this.logout());
            this.addButton((Widget)logoutButton);
        }
        this.pastebinBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 130, 160, 10){

            protected void onFocusedChanged(boolean focused) {
                if (focused) {
                    this.func_146202_e();
                    this.func_146199_i(0);
                }
                super.onFocusedChanged(focused);
            }
        };
        this.addButton((Widget)this.pastebinBox);
        WidgetButtonExtended pasteButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 78, 120, 20, I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.button.upload", (Object[])new Object[0]), b -> this.sendToPastebin());
        this.addButton((Widget)pasteButton);
        WidgetButtonExtended getButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 167, 120, 20, I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.button.get", (Object[])new Object[0]), b -> this.getFromPastebin());
        this.addButton((Widget)getButton);
        WidgetButtonExtended putInClipBoard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 78, 20, 20, "", b -> this.putToClipboard());
        putInClipBoard.setRenderedIcon(Textures.GUI_COPY_ICON_LOCATION);
        putInClipBoard.setTooltipText(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.button.copyToClipboard", (Object[])new Object[0]));
        this.addButton((Widget)putInClipBoard);
        WidgetButtonExtended retrieveFromClipboard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 167, 20, 20, "", b -> this.getFromClipboard());
        retrieveFromClipboard.setRenderedIcon(Textures.GUI_PASTE_ICON_LOCATION);
        retrieveFromClipboard.setTooltipText(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.button.loadFromClipboard", (Object[])new Object[0]));
        this.addButton((Widget)retrieveFromClipboard);
        this.prettyCB = new WidgetCheckBox(0, this.guiTop + 102, -12566464, I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.pretty", (Object[])new Object[0]), b -> {
            this.shouldMerge = b.checked;
        });
        this.prettyCB.x = this.guiLeft + (170 - this.prettyCB.getWidth());
        this.prettyCB.setTooltip(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.pretty.tooltip", (Object[])new Object[0])));
        this.addButton(this.prettyCB);
        WidgetCheckBox mergeCB = new WidgetCheckBox(0, this.guiTop + 155, -12566464, I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.merge", (Object[])new Object[0]), b -> {
            this.shouldMerge = b.checked;
        });
        mergeCB.x = this.guiLeft + (170 - mergeCB.getWidth());
        mergeCB.setTooltip(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.merge.tooltip", (Object[])new Object[0])));
        this.addButton(mergeCB);
        this.addLabel(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.pastebinLink", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 120);
    }

    private void login() {
        PastebinHandler.login(this.usernameBox.func_146179_b(), this.passwordBox.func_146179_b());
        this.state = EnumState.LOGIN;
        this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.loggingIn", (Object[])new Object[0]);
    }

    private void logout() {
        PastebinHandler.logout();
        this.state = EnumState.LOGOUT;
    }

    private void sendToPastebin() {
        PastebinHandler.put(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.state = EnumState.PUTTING;
        this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.uploadingToPastebin", (Object[])new Object[0]);
    }

    private void getFromPastebin() {
        PastebinHandler.get(this.pastebinBox.func_146179_b());
        this.state = EnumState.GETTING;
        this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.retrievingFromPastebin", (Object[])new Object[0]);
    }

    private void putToClipboard() {
        this.minecraft.field_195559_v.func_197960_a(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.clipboardSetToContents", (Object[])new Object[0]);
    }

    private void getFromClipboard() {
        this.readFromString(this.minecraft.field_195559_v.func_197965_a());
        this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.retrievedFromClipboard", (Object[])new Object[0]);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state == EnumState.LOGOUT) {
            this.state = EnumState.NONE;
            this.init(this.minecraft, this.width, this.height);
        }
        if (this.state != EnumState.NONE && PastebinHandler.isDone()) {
            this.statusMessage = "";
            switch (this.state) {
                case GETTING: {
                    String pastebinText = PastebinHandler.getHandler().contents;
                    if (pastebinText != null) {
                        this.readFromString(pastebinText);
                        break;
                    }
                    this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.invalidPastebin", (Object[])new Object[0]);
                    break;
                }
                case PUTTING: {
                    if (PastebinHandler.getException() != null) {
                        this.statusMessage = PastebinHandler.getException().getMessage();
                        break;
                    }
                    String pastebinText = PastebinHandler.getHandler().getLink;
                    if (pastebinText == null) {
                        pastebinText = "<ERROR>";
                    }
                    if (pastebinText.contains("pastebin.com")) {
                        this.pastebinBox.func_146180_a(pastebinText);
                        this.setTempMessage(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.uploadedToPastebin", (Object[])new Object[0]));
                        break;
                    }
                    this.statusMessage = pastebinText;
                    break;
                }
                case LOGIN: {
                    if (!PastebinHandler.isLoggedIn()) {
                        this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.invalidLogin", (Object[])new Object[0]);
                    }
                    this.init();
                }
            }
            this.state = EnumState.NONE;
        }
        if (this.messageTimer > 0 && --this.messageTimer <= 0) {
            this.lastMessage = "";
        }
    }

    private void setTempMessage(String msg) {
        this.lastMessage = msg;
        this.messageTimer = 60;
    }

    private void readFromString(String string) {
        try {
            this.outputTag = new JsonToNBTConverter(string).convert();
            if (this.outputTag.func_74764_b("widgets")) {
                this.doLegacyConversion(this.outputTag);
            }
            this.setTempMessage(I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.retrievedFromPastebin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.statusMessage = I18n.func_135052_a((String)"pneumaticcraft.gui.pastebin.invalidFormattedPastebin", (Object[])new Object[0]);
        }
    }

    private void doLegacyConversion(CompoundNBT nbt) {
        ListNBT l = nbt.func_150295_c("widgets", 10);
        int areaConversions = 0;
        for (int i = 0; i < l.size(); ++i) {
            CompoundNBT subTag = l.func_150305_b(i);
            String newName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, subTag.func_74779_i("name"));
            subTag.func_74778_a("name", "pneumaticcraft:" + newName);
            if (!newName.equals("area")) continue;
            LegacyAreaWidgetConverter.EnumOldAreaType oldType = LegacyAreaWidgetConverter.EnumOldAreaType.values()[subTag.func_74762_e("type")];
            AreaType newType = LegacyAreaWidgetConverter.convertFromLegacyFormat(oldType, subTag.func_74762_e("typeInfo"));
            subTag.func_74778_a("type", newType.getName().toLowerCase());
            newType.writeToNBT(subTag);
            ++areaConversions;
        }
        nbt.func_218657_a("pneumaticcraft:progWidgets", (INBT)l);
        nbt.func_82580_o("widgets");
        if (areaConversions > 0) {
            Log.info("Pastebin import: converted %d legacy area widgets", areaConversions);
        }
    }

    @Override
    public void render(int x, int y, float partialTicks) {
        this.renderBackground();
        super.render(x, y, partialTicks);
        if (!this.statusMessage.isEmpty()) {
            this.font.func_175063_a(this.statusMessage, (float)(this.guiLeft + 5), (float)(this.guiTop + 5), -256);
        } else if (!this.lastMessage.isEmpty()) {
            this.font.func_175063_a(this.lastMessage, (float)(this.guiLeft + 5), (float)(this.guiTop + 5), -16711936);
        }
    }

    public void onClose() {
        this.minecraft.field_195559_v.func_197967_a(false);
        this.minecraft.func_147108_a(this.parentScreen);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_PASTEBIN;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static enum EnumState {
        NONE,
        GETTING,
        PUTTING,
        LOGIN,
        LOGOUT;

    }
}

