/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticInventoryItem;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiPneumaticArmor
extends GuiPneumaticInventoryItem {
    private final String registryName;
    private WidgetAnimatedStat statusStat;
    private final EquipmentSlotType equipmentSlot;

    public GuiPneumaticArmor(ContainerChargingStationItemInventory container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.registryName = this.itemStack.func_77973_b().getRegistryName().func_110623_a();
        this.equipmentSlot = ((ArmorItem)this.itemStack.func_77973_b()).func_185083_B_();
    }

    @Override
    public void init() {
        super.init();
        this.addAnimatedStat("pneumaticcraft.gui.tab.info", Textures.GUI_INFO_LOCATION, -7829249, true).setText("gui.tab.info.item." + this.registryName);
        this.statusStat = this.addAnimatedStat("Status", this.itemStack, -22016, false);
        this.addUpgradeTabs(this.itemStack.func_77973_b(), "armor." + this.equipmentSlot.toString().toLowerCase(), "armor.generic");
    }

    @Override
    public void tick() {
        super.tick();
        CommonArmorHandler.getHandlerForPlayer().initArmorInventory(this.equipmentSlot);
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        String black = TextFormatting.BLACK.toString();
        text.add(TextFormatting.WHITE + "Air Usage:");
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        float totalUsage = UpgradeRenderHandlerList.instance().getAirUsage((PlayerEntity)player, this.equipmentSlot, true);
        if (totalUsage > 0.0f) {
            List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(this.equipmentSlot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IUpgradeRenderHandler handler;
                float upgradeUsage;
                if (!CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player).isUpgradeRendererInserted(this.equipmentSlot, i) || !((upgradeUsage = (handler = renderHandlers.get(i)).getEnergyUsage(CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player).getUpgradeCount(this.equipmentSlot, EnumUpgrade.RANGE), (PlayerEntity)player)) > 0.0f)) continue;
                text.add(black + PneumaticCraftUtils.roundNumberTo(upgradeUsage, 1) + " mL/tick (" + handler.getUpgradeID() + ")");
            }
            text.add(black + "--------+");
            text.add(black + "" + PneumaticCraftUtils.roundNumberTo(totalUsage, 1) + " mL/tick");
        } else {
            text.add(black + "0.0 mL/tick");
        }
        text.add(TextFormatting.WHITE + "Estimated time remaining:");
        int airLeft = (Integer)this.itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(IAirHandler::getAir).orElseThrow(RuntimeException::new);
        if (totalUsage == 0.0f) {
            if (airLeft > 0) {
                text.add(black + "infinite");
            } else {
                text.add(black + "0s");
            }
        } else {
            text.add(black + "" + PneumaticCraftUtils.convertTicksToMinutesAndSeconds((int)((float)airLeft / totalUsage), false));
        }
        return text;
    }

    @Override
    protected int getDefaultVolume() {
        return ((ItemPneumaticArmor)this.itemStack.func_77973_b()).getBaseVolume();
    }
}

