/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticDynamo;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDynamo;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GuiPneumaticDynamo
extends GuiPneumaticContainerBase<ContainerPneumaticDynamo, TileEntityPneumaticDynamo> {
    private WidgetAnimatedStat inputStat;
    private WidgetTemperature tempWidget;

    public GuiPneumaticDynamo(ContainerPneumaticDynamo container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.inputStat = this.addAnimatedStat("Output", Textures.GUI_BUILDCRAFT_ENERGY, -11184811, false);
        ((TileEntityPneumaticDynamo)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> {
            WidgetEnergy cfr_ignored_0 = (WidgetEnergy)this.addButton(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, (IEnergyStorage)storage));
        });
        this.tempWidget = new WidgetTemperature(this.field_147003_i + 97, this.field_147009_r + 20, TemperatureRange.of(273, 673), 273, 50).setOperatingRange(TemperatureRange.of(323, 625)).setShowOperatingRange(false);
        this.addButton(this.tempWidget);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    public void tick() {
        super.tick();
        this.inputStat.setText(this.getOutputStat());
        ((TileEntityPneumaticDynamo)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(h -> this.tempWidget.setTemperature(h.getTemperatureAsInt()));
        this.tempWidget.autoScaleForTemperature();
    }

    private List<String> getOutputStat() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.status.pneumaticDynamo.maxEnergyProduction", (Object[])new Object[0]));
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityPneumaticDynamo)this.te).getRFRate() + " FE/t");
        textList.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.status.pneumaticDynamo.maxOutputRate", (Object[])new Object[0]));
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityPneumaticDynamo)this.te).getRFRate() * 2 + " FE/t");
        textList.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.status.fluxCompressor.storedEnergy", (Object[])new Object[0]));
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityPneumaticDynamo)this.te).getInfoEnergyStored() + " FE");
        return textList;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.maxUsage", (Object[])new Object[]{((TileEntityPneumaticDynamo)this.te).getAirRate()}));
    }

    @Override
    public void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (((TileEntityPneumaticDynamo)this.te).getEfficiency() < 100) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.advancedAirCompressor.efficiency", (Object[])new Object[]{((TileEntityPneumaticDynamo)this.te).getEfficiency() + "%%"}));
        }
    }

    @Override
    protected PointXY getGaugeLocation() {
        return super.getGaugeLocation().add(10, 0);
    }
}

