/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiPneumaticInventoryItem
extends GuiPneumaticContainerBase<ContainerChargingStationItemInventory, TileEntityChargingStation> {
    protected final ItemStack itemStack;
    private Button guiBackButton;

    GuiPneumaticInventoryItem(ContainerChargingStationItemInventory container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.itemStack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        this.field_147000_g = 176;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_PNEUMATIC_ARMOR;
    }

    @Override
    public void init() {
        super.init();
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        this.guiBackButton = new WidgetButtonExtended(xStart + 152, yStart + 4, 18, 18, "\u2b05").withTag("close_upgrades");
        this.addButton((Widget)this.guiBackButton);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        int upgrades = UpgradableItemUtils.getUpgrades(this.itemStack, EnumUpgrade.VOLUME);
        int volume = ApplicableUpgradesDB.getInstance().getUpgradedVolume(this.getDefaultVolume(), upgrades);
        float curPressure = ((TileEntityChargingStation)this.te).chargingItemPressure;
        String col = TextFormatting.BLACK.toString();
        pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityChargingStation)this.te).chargingItemPressure, 2)}));
        pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.air", (Object[])new Object[]{String.format("%,d", Math.round(curPressure * (float)volume))}));
        pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.baseVolume", (Object[])new Object[]{String.format("%,d", this.getDefaultVolume())}));
        if (volume > this.getDefaultVolume()) {
            pressureStatText.add(col + "\u25b6" + " " + upgrades + " x " + EnumUpgrade.VOLUME.getItemStack().func_200301_q().func_150254_d());
            pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.effectiveVolume", (Object[])new Object[]{String.format("%,d", volume)}));
        }
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected abstract int getDefaultVolume();

    @Override
    protected void func_146979_b(int x, int y) {
        String containerName = this.itemStack.func_200301_q().func_150254_d();
        this.font.func_211126_b(containerName, (float)this.field_146999_f / 2.0f - (float)this.font.func_78256_a(containerName) / 2.0f, 5.0f, 0x404040);
        this.itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> PressureGaugeRenderer.drawPressureGauge(this.font, 0.0f, h.maxPressure(), h.maxPressure(), 0.0f, ((TileEntityChargingStation)this.te).chargingItemPressure, this.field_146999_f * 3 / 4 + 10, this.field_147000_g / 4 + 4));
    }

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.guiBackButton.onPress();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    void addUpgradeTabs(Item item, String ... what) {
        boolean leftSided = true;
        for (EnumUpgrade upgrade : EnumUpgrade.values()) {
            int max = ApplicableUpgradesDB.getInstance().getMaxUpgrades(item, upgrade);
            if (max <= 0) continue;
            ItemStack upgradeStack = upgrade.getItemStack();
            ArrayList<String> text = new ArrayList<String>();
            text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.upgrades.max", (Object[])new Object[]{max}));
            for (String w : what) {
                String key = "pneumaticcraft.gui.tab.info.item." + w + "." + upgrade.getName() + "Upgrade";
                if (!I18n.func_188566_a((String)key)) continue;
                text.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)key, (Object[])new Object[0])));
                break;
            }
            this.addAnimatedStat(upgradeStack.func_200301_q().func_150254_d(), upgradeStack, -10460929, leftSided).setTextWithoutCuttingString(text);
            leftSided = !leftSided;
        }
    }
}

