/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.event.ClientTickHandler;
import me.desht.pneumaticcraft.client.gui.GuiSecurityStationBase;
import me.desht.pneumaticcraft.client.gui.NetworkConnectionAIHandler;
import me.desht.pneumaticcraft.client.gui.NetworkConnectionBackground;
import me.desht.pneumaticcraft.client.gui.NetworkConnectionPlayerHandler;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationHacking;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSecurityStationFailedHack;
import me.desht.pneumaticcraft.common.network.PacketUseItem;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiSecurityStationHacking
extends GuiSecurityStationBase<ContainerSecurityStationHacking> {
    private WidgetAnimatedStat statusStat;
    private NetworkConnectionBackground playerBackgroundBridges;
    private NetworkConnectionBackground aiBackgroundBridges;
    private NetworkConnectionPlayerHandler hackerBridges;
    private NetworkConnectionAIHandler aiBridges;
    private int stopWorms = 0;
    private int nukeViruses = 0;
    private final ItemStack stopWorm = new ItemStack((IItemProvider)ModItems.STOP_WORM.get());
    private final ItemStack nukeVirus = new ItemStack((IItemProvider)ModItems.NUKE_VIRUS.get());

    public GuiSecurityStationHacking(ContainerSecurityStationHacking container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 238;
    }

    public static void addExtraHackInfoStatic(List<ITextComponent> curInfo) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiSecurityStationHacking) {
            ((GuiSecurityStationHacking)Minecraft.func_71410_x().field_71462_r).addExtraHackInfo(curInfo);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_HACKING;
    }

    @Override
    public void init() {
        super.init();
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        this.statusStat = this.addAnimatedStat("Security Status", new ItemStack((IItemProvider)ModBlocks.SECURITY_STATION.get()), -22016, false);
        this.addAnimatedStat("pneumaticcraft.gui.tab.info", Textures.GUI_INFO_LOCATION, -7829249, true).setText("pneumaticcraft.gui.tab.info.tile.security_station.hacking");
        this.addAnimatedStat("pneumaticcraft.gui.tab.upgrades", Textures.GUI_UPGRADES_LOCATION, -16776961, true).setText("pneumaticcraft.gui.tab.upgrades.tile.security_station.hacking");
        this.addAnimatedStat(((Item)ModItems.NUKE_VIRUS.get()).func_77658_a() + ".name", new ItemStack((IItemProvider)ModItems.NUKE_VIRUS.get()), -15152664, false).setText("gui.tab.info.tile.security_station.nukeVirus");
        this.addAnimatedStat(((Item)ModItems.STOP_WORM.get()).func_77658_a() + ".name", new ItemStack((IItemProvider)ModItems.STOP_WORM.get()), -4115918, false).setText("gui.tab.info.tile.security_station.stopWorm");
        if (this.playerBackgroundBridges == null) {
            this.playerBackgroundBridges = new NetworkConnectionBackground(this, (TileEntitySecurityStation)this.te, xStart + 21, yStart + 26, 31, -1438366465);
            this.aiBackgroundBridges = new NetworkConnectionBackground(this, (TileEntitySecurityStation)this.te, xStart + 23, yStart + 27, 31, -1438366465);
            this.hackerBridges = new NetworkConnectionPlayerHandler(this, (TileEntitySecurityStation)this.te, xStart + 21, yStart + 26, 31, -16711936);
            this.aiBridges = new NetworkConnectionAIHandler(this, (TileEntitySecurityStation)this.te, xStart + 23, yStart + 27, 31, -65536);
        } else {
            this.playerBackgroundBridges = new NetworkConnectionBackground(this.playerBackgroundBridges, xStart + 21, yStart + 26);
            this.aiBackgroundBridges = new NetworkConnectionBackground(this.aiBackgroundBridges, xStart + 23, yStart + 27);
            this.hackerBridges = new NetworkConnectionPlayerHandler(this.hackerBridges, xStart + 21, yStart + 26);
            this.aiBridges = new NetworkConnectionAIHandler(this.aiBridges, xStart + 23, yStart + 27);
        }
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.font.func_211126_b((this.aiBridges.isTracing() ? TextFormatting.RED : TextFormatting.GREEN) + "Tracing: " + PneumaticCraftUtils.convertTicksToMinutesAndSeconds(this.aiBridges.getRemainingTraceTime(), true), 15.0f, 7.0f, 0x404040);
        this.renderConsumables();
    }

    private void renderConsumables() {
        this.stopWorms = 0;
        this.nukeViruses = 0;
        for (ItemStack stack : this.field_213127_e.field_70462_a) {
            if (stack.func_77973_b() == ModItems.STOP_WORM.get()) {
                this.stopWorms += stack.func_190916_E();
            }
            if (stack.func_77973_b() != ModItems.NUKE_VIRUS.get()) continue;
            this.nukeViruses += stack.func_190916_E();
        }
        GuiUtils.drawItemStack(this.nukeVirus, 155, 30);
        GuiUtils.drawItemStack(this.stopWorm, 155, 55);
        this.font.func_211126_b(PneumaticCraftUtils.convertAmountToString(this.nukeViruses), 155.0f, 45.0f, -1);
        this.font.func_211126_b(PneumaticCraftUtils.convertAmountToString(this.stopWorms), 155.0f, 70.0f, -1);
    }

    @Override
    public void tick() {
        super.tick();
        this.statusStat.setText(this.getStatusText());
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        ArrayList<String> text;
        super.func_146976_a(opacity, x, y);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.playerBackgroundBridges.render();
        this.aiBackgroundBridges.render();
        this.hackerBridges.render();
        this.aiBridges.render();
        if (x >= this.field_147003_i + 155 && x <= this.field_147003_i + 171 && y >= this.field_147009_r + 30 && y <= this.field_147009_r + 50) {
            text = new ArrayList<String>();
            text.add("Nuke Virus");
            if (this.hasNukeViruses()) {
                text.add(TextFormatting.GRAY + "Middle-click a hackable node to use.");
            } else {
                text.add(TextFormatting.RED + "You don't have any Nuke Viruses.");
            }
            this.drawHoveringString(text, x, y, this.font);
        }
        if (x >= this.field_147003_i + 155 && x <= this.field_147003_i + 171 && y >= this.field_147009_r + 55 && y <= this.field_147009_r + 75) {
            text = new ArrayList();
            text.add("STOP! Worm");
            if (this.stopWorms > 0) {
                if (this.aiBridges.isTracing()) {
                    text.add(TextFormatting.GRAY + "Left-click to use.");
                } else {
                    text.add(TextFormatting.GRAY + "STOP! Worms can only be used when being traced.");
                }
            } else {
                text.add(TextFormatting.RED + "You don't have any STOP! Worms.");
            }
            this.drawHoveringString(text, x, y, this.font);
        }
    }

    @Override
    protected void addProblems(List<String> text) {
        super.addProblems(text);
        if (this.aiBridges.isTracing()) {
            text.add(TextFormatting.GRAY + "Intrusion detected!");
            text.add(TextFormatting.BLACK + "Time till trace: " + PneumaticCraftUtils.convertTicksToMinutesAndSeconds(this.aiBridges.getRemainingTraceTime(), false));
        }
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.GRAY + "Security Level");
        text.add(TextFormatting.BLACK + "Level " + ((TileEntitySecurityStation)this.te).getSecurityLevel());
        text.add(TextFormatting.GRAY + "Security Range");
        text.add(TextFormatting.BLACK.toString() + ((TileEntitySecurityStation)this.te).getSecurityRange() + "m (square)");
        return text;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 2) {
            int mx = (int)mouseX;
            int my = (int)mouseY;
            this.hackerBridges.mouseClicked(mx, my, mouseButton, this.getSlotAtPosition(mx, my));
            if (this.aiBridges.isTracing() && mouseX >= (double)(this.field_147003_i + 155) && mouseX <= (double)(this.field_147003_i + 171) && mouseY >= (double)(this.field_147009_r + 55) && mouseY <= (double)(this.field_147009_r + 75)) {
                NetworkHandler.sendToServer(new PacketUseItem(new ItemStack((IItemProvider)ModItems.STOP_WORM.get())));
                PneumaticCraftUtils.consumeInventoryItem(this.field_213127_e, (Item)ModItems.STOP_WORM.get());
                this.aiBridges.applyStopWorm();
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void addExtraHackInfo(List<ITextComponent> currenttip) {
        int mouseY;
        int mouseX = (int)this.minecraft.field_71417_B.func_198024_e() * this.width / this.minecraft.func_228018_at_().func_198105_m();
        Slot slot = this.getSlotAtPosition(mouseX, mouseY = this.height - (int)this.minecraft.field_71417_B.func_198026_f() * this.height / this.minecraft.func_228018_at_().func_198083_n() - 1);
        if (slot != null) {
            if (this.hackerBridges.slotHacked[slot.field_75222_d]) {
                if (!this.hackerBridges.slotFortified[slot.field_75222_d]) {
                    currenttip.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.detectionChance", ((TileEntitySecurityStation)this.te).getDetectionChance()).func_211708_a(TextFormatting.RED));
                    currenttip.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.rightClickFortify", new Object[0]).func_211708_a(TextFormatting.YELLOW));
                }
            } else if (this.hackerBridges.canHackSlot(slot.field_75222_d)) {
                currenttip.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.detectionChance", ((TileEntitySecurityStation)this.te).getDetectionChance()).func_211708_a(TextFormatting.RED));
                currenttip.add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.leftClickHack", new Object[0]).func_211708_a(TextFormatting.GREEN));
            }
        }
    }

    boolean hasNukeViruses() {
        return this.nukeViruses > 0;
    }

    void onSlotHack(int slot) {
        if (Math.random() < (double)((TileEntitySecurityStation)this.te).getDetectionChance() / 100.0) {
            this.aiBridges.setTracing(true);
        }
    }

    void onSlotFortification(int slot) {
        this.aiBridges.slotFortified[slot] = true;
        if (Math.random() < (double)((TileEntitySecurityStation)this.te).getDetectionChance() / 100.0) {
            this.aiBridges.setTracing(true);
        }
    }

    @Override
    public void onClose() {
        if (this.aiBridges.isTracing() && !this.hackerBridges.hackedSuccessfully) {
            NetworkHandler.sendToServer(new PacketSecurityStationFailedHack(((TileEntitySecurityStation)this.te).func_174877_v()));
        }
        this.removeUpdatesOnConnectionHandlers();
        super.onClose();
    }

    void removeUpdatesOnConnectionHandlers() {
        ClientTickHandler.instance().removeUpdatedObject(this.hackerBridges);
        ClientTickHandler.instance().removeUpdatedObject(this.aiBridges);
    }
}

