/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerSentryTurret;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySentryTurret;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiSentryTurret
extends GuiPneumaticContainerBase<ContainerSentryTurret, TileEntitySentryTurret> {
    private WidgetTextField entityFilter;
    private WidgetButtonExtended errorButton;

    public GuiSentryTurret(ContainerSentryTurret container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SENTRY_TURRET;
    }

    @Override
    public void init() {
        super.init();
        this.font.getClass();
        this.entityFilter = new WidgetTextField(this.font, this.field_147003_i + 80, this.field_147009_r + 63, 70, 9);
        this.addButton((Widget)this.entityFilter);
        this.entityFilter.func_146203_f(256);
        this.entityFilter.func_146195_b(true);
        this.setFocused((IGuiEventListener)this.entityFilter);
        this.errorButton = new WidgetButtonExtended(this.field_147003_i + 155, this.field_147009_r + 52, 16, 16, "");
        this.addButton((Widget)this.errorButton);
        this.errorButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE).setVisible(false);
    }

    @Override
    public void tick() {
        if (this.firstUpdate) {
            this.entityFilter.func_146180_a(((TileEntitySentryTurret)this.te).getText(0));
            this.entityFilter.func_212954_a(this::onEntityFilterChanged);
        }
        super.tick();
        this.errorButton.visible = !this.errorButton.getTooltip().isEmpty();
    }

    private void onEntityFilterChanged(String newText) {
        try {
            new EntityFilter(newText);
            this.errorButton.setTooltipText("");
            this.sendDelayed(5);
        }
        catch (IllegalArgumentException e) {
            this.errorButton.setTooltipText(e.getMessage());
        }
    }

    @Override
    protected void doDelayedAction() {
        ((TileEntitySentryTurret)this.te).setText(0, this.entityFilter.func_146179_b());
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.font.func_211126_b(I18n.func_135052_a((String)"pneumaticcraft.gui.sentryTurret.ammo", (Object[])new Object[0]), 80.0f, 19.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"pneumaticcraft.gui.sentryTurret.targetFilter", (Object[])new Object[0]), 80.0f, 53.0f, 0x404040);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen((Screen)this, this.font, PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter.helpText", (Object[])new Object[0]), 60));
        } else if (x >= this.field_147003_i + 76 && y >= this.field_147009_r + 51 && x <= this.field_147003_i + 153 && y <= this.field_147009_r + 74) {
            String str = I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter", (Object[])new Object[0]);
            this.font.func_211126_b(str, (float)(this.field_146999_f - this.font.func_78256_a(str)) / 2.0f, (float)(this.field_147000_g + 5), 0x808080);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return this.entityFilter.keyPressed(keyCode, scanCode, modifiers) || this.entityFilter.func_212955_f() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        boolean hasAmmo = false;
        for (int i = 0; i < ((TileEntitySentryTurret)this.te).getPrimaryInventory().getSlots(); ++i) {
            if (((TileEntitySentryTurret)this.te).getPrimaryInventory().getStackInSlot(i).func_190926_b()) continue;
            hasAmmo = true;
            break;
        }
        if (!hasAmmo) {
            curInfo.add("pneumaticcraft.gui.tab.problems.sentryTurret.noAmmo");
        }
    }
}

