/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.tileentity.TileEntityThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.IFluidTank;

public class GuiThermopneumaticProcessingPlant
extends GuiPneumaticContainerBase<ContainerThermopneumaticProcessingPlant, TileEntityThermopneumaticProcessingPlant> {
    private WidgetTemperature tempWidget;
    private WidgetButtonExtended dumpButton;
    private int nExposedFaces;

    public GuiThermopneumaticProcessingPlant(ContainerThermopneumaticProcessingPlant container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 212;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_THERMOPNEUMATIC_PROCESSING_PLANT;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new WidgetTank(this.field_147003_i + 13, this.field_147009_r + 19, (IFluidTank)((TileEntityThermopneumaticProcessingPlant)this.te).getInputTank()));
        this.addButton(new WidgetTank(this.field_147003_i + 79, this.field_147009_r + 19, (IFluidTank)((TileEntityThermopneumaticProcessingPlant)this.te).getOutputTank()));
        this.tempWidget = new WidgetTemperature(this.field_147003_i + 105, this.field_147009_r + 25, TemperatureRange.of(273, 673), 273, 50);
        this.addButton(this.tempWidget);
        this.dumpButton = new WidgetButtonExtended(this.field_147003_i + 12, this.field_147009_r + 86, 18, 20, "").withTag("dump");
        this.dumpButton.setRenderedIcon(Textures.GUI_RIGHT_ARROW);
        this.dumpButton.setTooltipText(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.thermopneumatic.moveInput", (Object[])new Object[0])));
        this.addButton((Widget)this.dumpButton);
        this.nExposedFaces = HeatUtil.countExposedFaces(Collections.singletonList(this.te));
    }

    @Override
    public void tick() {
        super.tick();
        if (((TileEntityThermopneumaticProcessingPlant)this.te).maxTemperature > ((TileEntityThermopneumaticProcessingPlant)this.te).minTemperature) {
            this.tempWidget.setOperatingRange(TemperatureRange.of(((TileEntityThermopneumaticProcessingPlant)this.te).minTemperature, ((TileEntityThermopneumaticProcessingPlant)this.te).maxTemperature));
        } else {
            this.tempWidget.setOperatingRange(null);
        }
        ((TileEntityThermopneumaticProcessingPlant)this.te).getHeatCap(null).ifPresent(l -> this.tempWidget.setTemperature(l.getTemperatureAsInt()));
        this.tempWidget.autoScaleForTemperature();
        if (GuiThermopneumaticProcessingPlant.hasShiftDown()) {
            this.dumpButton.setRenderedIcon(Textures.GUI_X_BUTTON);
            this.dumpButton.setTooltipText(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.thermopneumatic.dumpInput", (Object[])new Object[0])));
        } else {
            this.dumpButton.setRenderedIcon(Textures.GUI_RIGHT_ARROW);
            this.dumpButton.setTooltipText(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.thermopneumatic.moveInput", (Object[])new Object[0])));
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int x, int y) {
        super.func_146976_a(partialTicks, x, y);
        double progress = ((TileEntityThermopneumaticProcessingPlant)this.te).getCraftingPercentage();
        int progressWidth = (int)(progress * 48.0);
        this.bindGuiTexture();
        this.blit(this.field_147003_i + 30, this.field_147009_r + 36, this.field_146999_f, 0, progressWidth, 30);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        String containerName = this.title.func_150254_d();
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)0.95, (double)1.0, (double)1.0);
        this.font.func_211126_b(containerName, (float)this.field_146999_f / 2.0f - (float)this.font.func_78256_a(containerName) / 2.1f, 5.0f, 0x404040);
        RenderSystem.popMatrix();
        super.func_146979_b(x, y);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        return new PointXY(xStart + this.field_146999_f * 3 / 4 + 14, yStart + this.field_147000_g / 4 - 2);
    }

    @Override
    public void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (!((TileEntityThermopneumaticProcessingPlant)this.te).hasRecipe) {
            curInfo.add("pneumaticcraft.gui.tab.problems.thermopneumaticProcessingPlant.noSufficientIngredients");
        } else {
            int temp = (Integer)((TileEntityThermopneumaticProcessingPlant)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).map(IHeatExchangerLogic::getTemperatureAsInt).orElseThrow(RuntimeException::new);
            if (temp < ((TileEntityThermopneumaticProcessingPlant)this.te).minTemperature) {
                curInfo.add("pneumaticcraft.gui.tab.problems.notEnoughHeat");
            }
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        if (this.nExposedFaces > 0) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.exposedFaces", (Object[])new Object[]{this.nExposedFaces, 6}));
        }
    }
}

