/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorSetting;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerUniversalSensor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUniversalSensor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiUniversalSensor
extends GuiPneumaticContainerBase<ContainerUniversalSensor, TileEntityUniversalSensor> {
    private WidgetAnimatedStat sensorInfoStat;
    private TextFieldWidget nameFilterField;
    private int page;
    private int maxPage;
    private static final int MAX_SENSORS_PER_PAGE = 4;
    private int ticksExisted;
    private final List<Widget> sensorButtons = new ArrayList<Widget>();

    public GuiUniversalSensor(ContainerUniversalSensor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 239;
    }

    public static void maybeUpdateButtons() {
        Screen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiUniversalSensor) {
            ((GuiUniversalSensor)guiScreen).updateButtons();
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_UNIVERSAL_SENSOR;
    }

    @Override
    public void init() {
        super.init();
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        this.sensorInfoStat = this.addAnimatedStat("Sensor Info", new ItemStack((IItemProvider)ModBlocks.UNIVERSAL_SENSOR.get()), -22016, false);
        this.nameFilterField = new TextFieldWidget(this.font, xStart + 70, yStart + 58, 98, 10, "");
        this.nameFilterField.func_146180_a(((TileEntityUniversalSensor)this.te).getText(0));
        this.nameFilterField.func_212954_a(s -> this.sendDelayed(5));
        this.addButton((Widget)this.nameFilterField);
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int x, int y) {
        String[] folders;
        super.func_146979_b(x, y);
        if (this.maxPage > 1) {
            this.font.func_211126_b(this.page + "/" + this.maxPage, 110.0f, 134.0f, 0x404040);
        }
        if ((folders = ((TileEntityUniversalSensor)this.te).getSensorSetting().split("/")).length == 1 && !folders[0].isEmpty()) {
            Set<EnumUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText(folders[0]);
            int curX = 92;
            for (EnumUpgrade upgrade : requiredUpgrades) {
                GuiUtils.drawItemStack(upgrade.getItemStack(), curX, 20);
                curX += 18;
            }
        } else {
            int xSpace = this.field_146999_f - 96;
            int size = this.font.func_78256_a(folders[folders.length - 1]);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)92.0, (double)24.0, (double)0.0);
            if (size > xSpace) {
                RenderSystem.scaled((double)((float)xSpace / (float)size), (double)1.0, (double)1.0);
            }
            this.font.func_211126_b(folders[folders.length - 1], 0.0f, 0.0f, 0x4040A0);
            RenderSystem.popMatrix();
        }
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen((Screen)this, this.font, PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter.helpText", (Object[])new Object[0]), 60));
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return this.nameFilterField.keyPressed(keyCode, scanCode, modifiers) || this.nameFilterField.func_212955_f() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        if (sensor != null) {
            RenderSystem.translated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
            sensor.drawAdditionalInfo(this.font);
            RenderSystem.translated((double)(-this.field_147003_i), (double)(-this.field_147009_r), (double)0.0);
        }
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        return new PointXY(xStart + 34, yStart + this.field_147000_g / 4 - 18);
    }

    private void updateButtons() {
        this.sensorButtons.forEach(w -> {
            this.buttons.remove(w);
            this.children.remove(w);
        });
        this.sensorButtons.clear();
        String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(((TileEntityUniversalSensor)this.te).getSensorSetting());
        if (!((TileEntityUniversalSensor)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((Widget)new WidgetButtonExtended(this.field_147003_i + 70, this.field_147009_r + 18, 20, 20, "\u2b05").withTag("back"));
        }
        if (directories.length == 0 || ((TileEntityUniversalSensor)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((Widget)new WidgetButtonExtended(this.field_147003_i + 70, this.field_147009_r + 125, 98, 20, I18n.func_135052_a((String)"pneumaticcraft.gui.button.showRange", (Object[])new Object[0]), b -> {
                this.onClose();
                ((TileEntityUniversalSensor)this.te).showRangeLines();
            }));
        }
        this.maxPage = (directories.length - 1) / 4 + 1;
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.maxPage > 1) {
            this.addButtonLocal((Widget)new WidgetButtonExtended(this.field_147003_i + 70, this.field_147009_r + 40 + 88, 30, 20, "\u27f5", b -> {
                --this.page;
                if (this.page <= 0) {
                    this.page = this.maxPage;
                }
                this.updateButtons();
            }));
            this.addButtonLocal((Widget)new WidgetButtonExtended(this.field_147003_i + 138, this.field_147009_r + 40 + 88, 30, 20, "\u27f6", b -> {
                ++this.page;
                if (this.page > this.maxPage) {
                    this.page = 1;
                }
                this.updateButtons();
            }));
        }
        int buttonsOnPage = 4;
        if (this.page == this.maxPage && (directories.length % 4 > 0 || directories.length == 0)) {
            buttonsOnPage = directories.length % 4;
        }
        for (int i = 0; i < buttonsOnPage; ++i) {
            String buttonText = directories[i + (this.page - 1) * 4];
            if (SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting() + "/" + buttonText) != null) {
                buttonText = TextFormatting.YELLOW + buttonText;
            }
            int buttonID = i * 10 + 10 + (this.page - 1) * 4 * 10;
            int buttonX = this.field_147003_i + 70;
            int buttonY = this.field_147009_r + 40 + i * 22;
            int buttonWidth = 98;
            int buttonHeight = 20;
            if (((TileEntityUniversalSensor)this.te).getSensorSetting().equals("")) {
                Set<EnumUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText(buttonText);
                WidgetButtonExtended button = new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, "").withTag("set:" + buttonID);
                button.setRenderStacks((ItemStack[])requiredUpgrades.stream().map(EnumUpgrade::getItemStack).toArray(ItemStack[]::new));
                button.active = (((TileEntityUniversalSensor)this.te).sensorStatus == TileEntityUniversalSensor.SensorStatus.OK || ((TileEntityUniversalSensor)this.te).sensorStatus == TileEntityUniversalSensor.SensorStatus.NO_SENSOR) && ((TileEntityUniversalSensor)this.te).areGivenUpgradesInserted(requiredUpgrades);
                this.addButtonLocal((Widget)button);
                continue;
            }
            this.addButtonLocal((Widget)new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, buttonText).withTag("set:" + buttonID));
        }
        this.sensorInfoStat.setText(this.getSensorInfo());
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        boolean textboxEnabled = sensor != null && sensor.needsTextBox();
        this.nameFilterField.func_146189_e(textboxEnabled);
        if (textboxEnabled) {
            this.setFocused((IGuiEventListener)this.nameFilterField);
        }
        this.nameFilterField.func_146195_b(textboxEnabled);
    }

    private void addButtonLocal(Widget w) {
        this.addButton(w);
        this.sensorButtons.add(w);
    }

    @Override
    protected void doDelayedAction() {
        ((TileEntityUniversalSensor)this.te).setText(0, this.nameFilterField.func_146179_b());
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    @Override
    public void tick() {
        super.tick();
        if (((TileEntityUniversalSensor)this.te).getSensorSetting().isEmpty() && this.ticksExisted++ > 5) {
            this.ticksExisted = 0;
            this.updateButtons();
        }
        if (!this.nameFilterField.isFocused()) {
            this.nameFilterField.func_146180_a(((TileEntityUniversalSensor)this.te).getText(0));
        }
    }

    private List<String> getSensorInfo() {
        ArrayList<String> text = new ArrayList<String>();
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        if (sensor != null) {
            String[] folders = ((TileEntityUniversalSensor)this.te).getSensorSetting().split("/");
            text.add(TextFormatting.WHITE + folders[folders.length - 1]);
            text.addAll(sensor.getDescription().stream().map(s -> TextFormatting.BLACK + I18n.func_135052_a((String)s, (Object[])new Object[0])).collect(Collectors.toList()));
        } else {
            text.add(TextFormatting.BLACK + "No sensor selected.");
        }
        return text;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityUniversalSensor)this.te).isSensorActive) {
            pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.airUsage", (Object[])new Object[]{1}));
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        if (!((TileEntityUniversalSensor)this.te).getPrimaryInventory().getStackInSlot(0).func_190926_b() && ((TileEntityUniversalSensor)this.te).outOfRange > 0) {
            curInfo.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.universalSensor.outOfRange", (Object[])new Object[]{((TileEntityUniversalSensor)this.te).outOfRange})));
        }
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (!((TileEntityUniversalSensor)this.te).lastSensorExceptionText.isEmpty()) {
            curInfo.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.universalSensor.sensorException", (Object[])new Object[]{((TileEntityUniversalSensor)this.te).lastSensorExceptionText})));
        }
        if (((TileEntityUniversalSensor)this.te).sensorStatus != TileEntityUniversalSensor.SensorStatus.OK) {
            curInfo.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)((TileEntityUniversalSensor)this.te).sensorStatus.getTranslationKey(), (Object[])new Object[0])));
        }
    }
}

