/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import java.util.ArrayList;
import java.util.Collections;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoordTrackUpgradeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;

public class GuiCoordinateTrackerOptions
extends IOptionPage.SimpleToggleableOptions<CoordTrackUpgradeHandler> {
    private Button wirePath;
    private Button pathEnabled;
    private Button xRayEnabled;
    private Button pathUpdateRate;
    private final CoordTrackUpgradeHandler coordHandler = HUDHandler.instance().getSpecificRenderer(CoordTrackUpgradeHandler.class);
    private final Minecraft mc = Minecraft.func_71410_x();

    public GuiCoordinateTrackerOptions(IGuiScreen screen, CoordTrackUpgradeHandler renderHandler) {
        super(screen, renderHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        gui.addWidget(new WidgetButtonExtended(30, 40, 150, 20, "Select Target...", b -> this.selectTarget()));
        gui.addWidget(new WidgetButtonExtended(30, 62, 150, 20, "Navigate to Surface...", b -> this.navigateToSurface()));
        this.pathEnabled = new WidgetButtonExtended(30, 128, 150, 20, "", b -> {
            this.coordHandler.pathEnabled = !this.coordHandler.pathEnabled;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.wirePath = new WidgetButtonExtended(30, 150, 150, 20, "", b -> {
            this.coordHandler.wirePath = !this.coordHandler.wirePath;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.xRayEnabled = new WidgetButtonExtended(30, 172, 150, 20, "", b -> {
            this.coordHandler.xRayEnabled = !this.coordHandler.xRayEnabled;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.pathUpdateRate = new WidgetButtonExtended(30, 194, 150, 20, "", b -> {
            this.coordHandler.pathUpdateSetting = this.coordHandler.pathUpdateSetting.cycle();
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        gui.addWidget(this.pathEnabled);
        gui.addWidget(this.wirePath);
        gui.addWidget(this.xRayEnabled);
        gui.addWidget(this.pathUpdateRate);
        this.updateButtonTexts();
    }

    private void selectTarget() {
        this.mc.field_71439_g.func_71053_j();
        this.mc.func_213228_a(true);
        this.coordHandler.isListeningToCoordTrackerSetting = true;
        HUDHandler.instance().addMessage(new ArmorMessage("Changing Coordinate Tracker coordinate...", Collections.singletonList("Right-click the desired coordinate"), 90, 0x7000AA00));
    }

    private void navigateToSurface() {
        this.mc.field_71439_g.func_71053_j();
        this.mc.func_213228_a(true);
        switch (this.coordHandler.navigateToSurface((PlayerEntity)this.mc.field_71439_g)) {
            case EASY_PATH: {
                HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticcraft.armor.message.coordinateTracker.routeFound", (Object[])new Object[0]), new ArrayList<String>(), 90, 0x7000AA00));
                break;
            }
            case DRONE_PATH: {
                HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticcraft.armor.message.coordinateTracker.harderRouteFound", (Object[])new Object[0]), new ArrayList<String>(), 90, 1883548160));
                break;
            }
            case NO_PATH: {
                HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticcraft.armor.message.coordinateTracker.noRouteFound", (Object[])new Object[0]), new ArrayList<String>(), 90, 0x70FF0000));
            }
        }
    }

    private void updateButtonTexts() {
        CoordTrackUpgradeHandler coordHandler = HUDHandler.instance().getSpecificRenderer(CoordTrackUpgradeHandler.class);
        this.pathEnabled.setMessage(coordHandler.pathEnabled ? "Navigation Enabled" : "Navigation Disabled");
        this.wirePath.setMessage(coordHandler.wirePath ? "Wire Navigation" : "Tile Navigation");
        this.xRayEnabled.setMessage(coordHandler.xRayEnabled ? "X-Ray Enabled" : "X-Ray Disabled");
        switch (coordHandler.pathUpdateSetting) {
            case SLOW: {
                this.pathUpdateRate.setMessage("Path update rate: Low");
                break;
            }
            case NORMAL: {
                this.pathUpdateRate.setMessage("Path update rate: Normal");
                break;
            }
            case FAST: {
                this.pathUpdateRate.setMessage("Path update rate: Fast");
            }
        }
        this.wirePath.active = coordHandler.pathEnabled;
        this.xRayEnabled.active = coordHandler.pathEnabled;
        this.pathUpdateRate.active = coordHandler.pathEnabled;
    }

    @Override
    public boolean displaySettingsHeader() {
        return true;
    }
}

