/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.semiblock;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.client.gui.GuiItemSearcher;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsLiquidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.inventory.SlotPhantom;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GuiLogisticsBase<L extends EntityLogisticsFrame>
extends GuiPneumaticContainerBase<ContainerLogistics, TileEntityBase> {
    protected final L logistics;
    private GuiItemSearcher itemSearchGui;
    private GuiLogisticsLiquidFilter fluidSearchGui;
    private int editingSlot;
    private final WidgetButtonExtended[] facingButtons = new WidgetButtonExtended[6];
    private WidgetAnimatedStat facingTab;
    private WidgetLabel itemLabel;
    private WidgetLabel fluidLabel;
    private final List<WidgetFluidStack> fluidWidgets = new ArrayList<WidgetFluidStack>();

    public GuiLogisticsBase(ContainerLogistics container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.logistics = container.logistics;
        this.field_147000_g = 216;
    }

    @Override
    public void init() {
        super.init();
        if (this.itemSearchGui != null) {
            this.updateItemFilter(this.editingSlot, this.itemSearchGui.getSearchStack());
            this.itemSearchGui = null;
        }
        if (this.fluidSearchGui != null && this.fluidSearchGui.getFilter() != null) {
            this.updateFluidFilter(this.editingSlot, new FluidStack(this.fluidSearchGui.getFilter(), 1000));
            this.fluidSearchGui = null;
        }
        String invisibleText = I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.invisible", (Object[])new Object[0]);
        WidgetCheckBox invisible = new WidgetCheckBox(this.field_147003_i + this.field_146999_f - 18 - this.font.func_78256_a(invisibleText), this.field_147009_r + 16, -12566464, invisibleText, b -> {
            ((EntityLogisticsFrame)this.logistics).setSemiblockInvisible(b.checked);
            this.syncToServer();
        }).setChecked(((EntityLogisticsFrame)this.logistics).isSemiblockInvisible());
        this.addButton(invisible);
        invisible.setTooltip(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.invisible.tooltip", (Object[])new Object[0]), 40));
        this.itemLabel = new WidgetLabel(this.field_147003_i + 8, this.field_147009_r + 18, "");
        this.addButton(this.itemLabel);
        this.fluidLabel = new WidgetLabel(this.field_147003_i + 8, this.field_147009_r + 90, "");
        this.addButton(this.fluidLabel);
        this.updateLabels();
        IntStream.range(0, 9).forEach(i -> {
            FluidStack stack = ((EntityLogisticsFrame)this.logistics).getFluidFilter(i);
            PointXY p = this.getFluidSlotPos(i);
            this.fluidWidgets.add(new WidgetFluidStack(p.x, p.y, stack.copy(), w -> this.fluidClicked((WidgetFluidStack)w, i)));
        });
        this.fluidWidgets.forEach(arg_0 -> ((GuiLogisticsBase)this).addButton(arg_0));
        this.addInfoTab(I18n.func_135052_a((String)("pneumaticcraft.gui.tooltip.item.pneumaticcraft." + ((EntitySemiblockBase)this.logistics).getId().func_110623_a()), (Object[])new Object[0]));
        this.addFilterTab();
        if (!((ContainerLogistics)this.field_147002_h).isItemContainer()) {
            this.addFacingTab();
        }
        this.addJeiFilterInfoTab();
    }

    public void updateItemFilter(int slot, ItemStack stack) {
        ((ContainerLogistics)this.field_147002_h).func_75139_a(slot).func_75215_d(stack);
        ((EntityLogisticsFrame)this.logistics).setItemFilter(slot, stack);
        this.syncToServer();
    }

    public void updateFluidFilter(int slot, FluidStack stack) {
        ((EntityLogisticsFrame)this.logistics).setFluidFilter(slot, stack);
        if (!this.fluidWidgets.isEmpty()) {
            this.fluidWidgets.get(slot).setFluidStack(stack);
        }
        this.syncToServer();
    }

    public PointXY getFluidSlotPos(int slot) {
        return new PointXY(this.field_147003_i + slot * 18 + 8, this.field_147009_r + 101);
    }

    private void updateLabels() {
        String s = ((EntityLogisticsFrame)this.logistics).isWhiteList() ? "" : TextFormatting.STRIKETHROUGH.toString();
        this.itemLabel.setMessage(s + I18n.func_135052_a((String)String.format("pneumaticcraft.gui.%s.itemFilters", ((EntitySemiblockBase)this.logistics).getId().func_110623_a()), (Object[])new Object[0]));
        this.fluidLabel.setMessage(s + I18n.func_135052_a((String)String.format("pneumaticcraft.gui.%s.fluidFilters", ((EntitySemiblockBase)this.logistics).getId().func_110623_a()), (Object[])new Object[0]));
    }

    private void syncToServer() {
        NetworkHandler.sendToServer(new PacketSyncSemiblock((ISemiBlock)this.logistics));
    }

    private void fluidClicked(WidgetFluidStack widget, int idx) {
        FluidStack stack = ((EntityLogisticsFrame)this.logistics).getFluidFilter(idx);
        if (!stack.isEmpty()) {
            ((EntityLogisticsFrame)this.logistics).setFluidFilter(idx, widget.getFluidStack().copy());
            this.syncToServer();
        } else {
            this.fluidSearchGui = new GuiLogisticsLiquidFilter((Screen)this);
            this.editingSlot = idx;
            this.minecraft.func_147108_a((Screen)this.fluidSearchGui);
        }
    }

    private void addFilterTab() {
        WidgetAnimatedStat filterTab = this.addAnimatedStat("pneumaticcraft.gui.logistics_frame.filter_settings", new ItemStack((IItemProvider)Blocks.field_196553_aF), -15704048, false);
        filterTab.addPadding(((EntityLogisticsFrame)this.logistics).supportsBlacklisting() ? 8 : 6, 28);
        WidgetCheckBox matchDurability = new WidgetCheckBox(5, 20, -1, I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.matchDurability", (Object[])new Object[0]), b -> {
            ((EntityLogisticsFrame)this.logistics).setMatchDurability(b.checked);
            this.syncToServer();
        }).setTooltip(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.matchDurability.tooltip", (Object[])new Object[0]), 40)).setChecked(((EntityLogisticsFrame)this.logistics).isMatchDurability());
        filterTab.addSubWidget(matchDurability);
        WidgetCheckBox matchNBT = new WidgetCheckBox(5, 36, -1, I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.matchNBT", (Object[])new Object[0]), b -> {
            ((EntityLogisticsFrame)this.logistics).setMatchNBT(b.checked);
            this.syncToServer();
        }).setTooltip(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.matchNBT.tooltip", (Object[])new Object[0]), 40)).setChecked(((EntityLogisticsFrame)this.logistics).isMatchNBT());
        filterTab.addSubWidget(matchNBT);
        WidgetCheckBox matchModId = new WidgetCheckBox(5, 52, -1, I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.matchModId", (Object[])new Object[0]), b -> {
            ((EntityLogisticsFrame)this.logistics).setMatchModId(b.checked);
            this.syncToServer();
        }).setTooltip(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.matchModId.tooltip", (Object[])new Object[0]), 40)).setChecked(((EntityLogisticsFrame)this.logistics).isMatchModId());
        filterTab.addSubWidget(matchModId);
        if (((EntityLogisticsFrame)this.logistics).supportsBlacklisting()) {
            WidgetCheckBox whitelist = new WidgetCheckBox(5, 73, -1, I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.whitelist", (Object[])new Object[0]), b -> {
                ((EntityLogisticsFrame)this.logistics).setWhiteList(b.checked);
                this.updateLabels();
                this.syncToServer();
            }).setChecked(((EntityLogisticsFrame)this.logistics).isWhiteList());
            filterTab.addSubWidget(whitelist);
        }
    }

    private void addFacingTab() {
        this.facingTab = this.addAnimatedStat("", new ItemStack((IItemProvider)Items.field_151148_bJ), -4144960, false);
        this.facingTab.addPadding(8, 18);
        this.facingButtons[0] = new WidgetButtonExtended(15, 62, 20, 20, "D", b -> this.setFace(Direction.DOWN));
        this.facingTab.addSubWidget((Widget)this.facingButtons[0]);
        this.facingButtons[1] = new WidgetButtonExtended(15, 20, 20, 20, "U", b -> this.setFace(Direction.UP));
        this.facingTab.addSubWidget((Widget)this.facingButtons[1]);
        this.facingButtons[2] = new WidgetButtonExtended(36, 20, 20, 20, "N", b -> this.setFace(Direction.NORTH));
        this.facingTab.addSubWidget((Widget)this.facingButtons[2]);
        this.facingButtons[3] = new WidgetButtonExtended(36, 62, 20, 20, "S", b -> this.setFace(Direction.SOUTH));
        this.facingTab.addSubWidget((Widget)this.facingButtons[3]);
        this.facingButtons[4] = new WidgetButtonExtended(15, 41, 20, 20, "W", b -> this.setFace(Direction.WEST));
        this.facingTab.addSubWidget((Widget)this.facingButtons[4]);
        this.facingButtons[5] = new WidgetButtonExtended(57, 41, 20, 20, "E", b -> this.setFace(Direction.EAST));
        this.facingTab.addSubWidget((Widget)this.facingButtons[5]);
        this.facingTab.addSubWidget((Widget)new WidgetButtonExtended(36, 41, 20, 20, "").setTooltipText(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.facing.tooltip", (Object[])new Object[0]))).setRenderedIcon(Textures.GUI_INFO_LOCATION).setVisible(false));
        this.updateFacing();
    }

    private void updateFacing() {
        String s = ((EntityLogisticsFrame)this.logistics).getFacing() == null ? "-" : ClientUtils.translateDirection(((EntityLogisticsFrame)this.logistics).getFacing());
        this.facingTab.setTitle(I18n.func_135052_a((String)"pneumaticcraft.gui.logistics_frame.facing", (Object[])new Object[]{s}));
        for (Direction face : Direction.values()) {
            this.facingButtons[face.func_176745_a()].active = face != ((EntityLogisticsFrame)this.logistics).getFacing();
        }
    }

    private void setFace(Direction face) {
        ((EntityLogisticsFrame)this.logistics).setFacing(face);
        this.syncToServer();
        this.updateFacing();
    }

    @Override
    protected int getBackgroundTint() {
        if (!PNCConfig.Client.logisticsGuiTint) {
            return super.getBackgroundTint();
        }
        int c = ((EntityLogisticsFrame)this.logistics).getColor();
        float[] hsb = TintColor.RGBtoHSB((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF, null);
        TintColor color = TintColor.getHSBColor(hsb[0], hsb[1] * 0.2f, hsb[2]);
        if ((double)hsb[2] < 0.7) {
            color = color.brighter();
        }
        return color.getRGB();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LOGISTICS_REQUESTER;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected void func_184098_a(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        if (slot instanceof SlotPhantom && this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && !slot.func_75216_d() && (clickedButton == 0 || clickedButton == 1)) {
            this.editingSlot = slot.getSlotIndex();
            ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.ITEM_SEARCHER.get()), (ITextComponent)new StringTextComponent("Searcher"));
            if (this.minecraft.field_71462_r instanceof GuiItemSearcher) {
                this.itemSearchGui = (GuiItemSearcher)this.minecraft.field_71462_r;
            }
        } else {
            super.func_184098_a(slot, slotId, clickedButton, clickType);
        }
    }
}

