/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import me.desht.pneumaticcraft.client.gui.tubemodule.GuiTubeModule;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.tubes.ModuleAirGrate;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateAirGrateModule;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class GuiAirGrateModule
extends GuiTubeModule<ModuleAirGrate> {
    private int sendTimer = 0;
    private WidgetButtonExtended warningButton;
    private TextFieldWidget textfield;

    public GuiAirGrateModule(BlockPos pos) {
        super(pos);
        this.ySize = 57;
    }

    @Override
    public void init() {
        super.init();
        this.addLabel(this.title.func_150254_d(), this.guiLeft + this.xSize / 2, this.guiTop + 5, WidgetLabel.Alignment.CENTRE);
        WidgetLabel label = this.addLabel(I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 30);
        this.addLabel(I18n.func_135052_a((String)"pneumaticcraft.gui.holdF1forHelp", (Object[])new Object[0]), this.guiLeft + this.xSize / 2, this.guiTop + this.ySize + 5, WidgetLabel.Alignment.CENTRE).setColor(-4144960);
        int tx = 12 + label.getWidth();
        this.textfield = new WidgetTextField(this.font, this.guiLeft + tx, this.guiTop + 29, this.xSize - tx - 10, 10);
        this.textfield.func_146180_a(((ModuleAirGrate)this.module).getEntityFilterString());
        this.textfield.func_212954_a(s -> {
            this.sendTimer = 5;
        });
        this.textfield.func_146195_b(true);
        this.setFocused((IGuiEventListener)this.textfield);
        this.addButton((Widget)this.textfield);
        this.warningButton = new WidgetButtonExtended(this.guiLeft + 152, this.guiTop + 20, 20, 20, "");
        this.warningButton.setVisible(false);
        this.warningButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        this.addButton((Widget)this.warningButton);
        this.validateEntityFilter(this.textfield.func_146179_b());
    }

    private void validateEntityFilter(String filter) {
        try {
            this.warningButton.visible = false;
            this.warningButton.setTooltipText("");
            new EntityFilter(filter);
        }
        catch (IllegalArgumentException e) {
            this.warningButton.visible = true;
            this.warningButton.setTooltipText(TextFormatting.GOLD + e.getMessage());
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (!this.textfield.isFocused()) {
            this.textfield.func_146180_a(((ModuleAirGrate)this.module).getEntityFilterString());
        }
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(this, this.font, PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter.helpText", (Object[])new Object[0]), 60));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.sendTimer > 0 && --this.sendTimer == 0) {
            NetworkHandler.sendToServer(new PacketUpdateAirGrateModule(this.module, this.textfield.func_146179_b()));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MODULE_SIMPLE;
    }
}

