/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiPressureModuleSimple;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiTubeModule;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneReceiving;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class GuiPressureModule
extends GuiTubeModule<TubeModule> {
    private TextFieldWidget lowerBoundField;
    private TextFieldWidget higherBoundField;
    private int graphLowY;
    private int graphHighY;
    private int graphLeft;
    private int graphRight;
    private Rectangle2d lowerBoundArea;
    private Rectangle2d higherBoundArea;
    private boolean grabLower;
    private boolean grabHigher;

    public GuiPressureModule(BlockPos pos) {
        super(pos);
        this.ySize = 191;
    }

    GuiPressureModule(TubeModule module) {
        super(module);
        this.ySize = 191;
    }

    @Override
    public void init() {
        super.init();
        int xStart = (this.width - this.xSize) / 2;
        int yStart = (this.height - this.ySize) / 2;
        this.addLabel("lower", this.guiLeft + 15, this.guiTop + 33);
        this.addLabel("bar", this.guiLeft + 50, this.guiTop + 44);
        this.addLabel("higher", this.guiLeft + 140, this.guiTop + 33);
        String titleText = this.title.func_150254_d();
        this.addLabel(titleText, this.width / 2 - this.font.func_78256_a(titleText) / 2, this.guiTop + 5);
        this.lowerBoundField = new TextFieldWidget(this.font, xStart + 15, yStart + 43, 30, 10, PneumaticCraftUtils.roundNumberTo(this.module.lowerBound, 1));
        this.lowerBoundField.func_212954_a(s -> this.updateBoundFromTextfield(0));
        this.addButton((Widget)this.lowerBoundField);
        this.higherBoundField = new TextFieldWidget(this.font, xStart + 140, yStart + 43, 30, 10, PneumaticCraftUtils.roundNumberTo(this.module.higherBound, 1));
        this.higherBoundField.func_212954_a(s -> this.updateBoundFromTextfield(1));
        this.addButton((Widget)this.higherBoundField);
        this.graphLowY = this.guiTop + 158;
        this.graphHighY = this.guiTop + 98;
        this.graphLeft = this.guiLeft + 22;
        this.graphRight = this.guiLeft + 172;
        this.addButton(new WidgetTooltipArea(this.graphLeft - 20, this.graphHighY, 25, this.graphLowY - this.graphHighY, "pneumaticcraft.gui.redstone"));
        this.addButton(new WidgetTooltipArea(this.graphLeft, this.graphLowY - 5, this.graphRight - this.graphLeft, 25, "pneumaticcraft.gui.threshold"));
        WidgetAnimatedStat stat = new WidgetAnimatedStat(this, "pneumaticcraft.gui.tab.info", WidgetAnimatedStat.StatIcon.of(Textures.GUI_INFO_LOCATION), xStart, yStart + 5, -7829249, null, true);
        stat.setText("pneumaticcraft.gui.tab.info.tubeModule");
        stat.setBeveled(true);
        this.addButton(stat);
        WidgetCheckBox advancedMode = new WidgetCheckBox(this.guiLeft + 6, this.guiTop + 20, -12566464, "pneumaticcraft.gui.tubeModule.advancedConfig", b -> {
            this.module.advancedConfig = b.checked;
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
        }).setTooltip(I18n.func_135052_a((String)"pneumaticcraft.gui.tubeModule.advancedConfig.tooltip", (Object[])new Object[0]));
        advancedMode.checked = true;
        this.addButton(advancedMode);
        this.higherBoundArea = new Rectangle2d(this.guiLeft + 11, this.guiTop + 59, 158, 15);
        this.lowerBoundArea = new Rectangle2d(this.guiLeft + 11, this.guiTop + 73, 158, 15);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_TUBE_MODULE;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.minecraft.func_110434_K().func_110577_a(this.getTexture());
        int scrollbarLowerBoundX = (int)((float)(this.guiLeft + 16) + 147.0f * (this.module.lowerBound / 31.0f));
        int scrollbarHigherBoundX = (int)((float)(this.guiLeft + 16) + 147.0f * (this.module.higherBound / 31.0f));
        this.blit(scrollbarLowerBoundX, this.guiTop + 73, 183, 0, 15, 12);
        this.blit(scrollbarHigherBoundX, this.guiTop + 59, 183, 0, 15, 12);
        this.renderGraph();
        if (this.module instanceof TubeModuleRedstoneReceiving) {
            this.module.onNeighborBlockUpdate();
            this.hLine(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - ((TubeModuleRedstoneReceiving)this.module).getReceivingRedstoneLevel()) / 15, -65536);
            String status = I18n.func_135052_a((String)"pneumaticcraft.gui.tubeModule.simpleConfig.threshold", (Object[])new Object[0]) + " " + PneumaticCraftUtils.roundNumberTo(((TubeModuleRedstoneReceiving)this.module).getThreshold(), 1) + " bar";
            this.font.func_211126_b(status, (float)this.guiLeft + (float)this.xSize / 2.0f - (float)this.font.func_78256_a(status) / 2.0f, (float)(this.guiTop + 175), -12566464);
        }
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        for (int i = 0; i < 16; ++i) {
            double y = (double)this.graphHighY + (double)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0;
            double x = (float)this.graphLeft + (float)(this.graphRight - this.graphLeft) * this.module.getThreshold(i) / 30.0f;
            bufferBuilder.func_225582_a_(x, y, 90.0).func_227885_a_(0.25f + (float)i * 0.05f, 0.0f, 0.0f, 1.0f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    private void renderGraph() {
        boolean longer;
        int i;
        this.vLine(this.graphLeft, this.graphHighY, this.graphLowY, -16777216);
        for (i = 0; i < 16; ++i) {
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                this.font.func_211126_b(i + "", (float)(this.graphLeft - 5 - this.font.func_78256_a(i + "")), (float)this.graphHighY + (float)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0f - 3.0f, -16777216);
                this.hLine(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, i == 0 ? -16777216 : 0x33000000);
            }
            this.hLine(this.graphLeft - (longer ? 5 : 3), this.graphLeft + 3, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, -16777216);
        }
        for (i = 0; i < 31; ++i) {
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                this.font.func_211126_b(i + "", (float)this.graphLeft + (float)((this.graphRight - this.graphLeft) * i) / 30.0f - (float)this.font.func_78256_a(i + "") / 2.0f + 1.0f, (float)(this.graphLowY + 6), -16777216);
                this.vLine(this.graphLeft + (this.graphRight - this.graphLeft) * i / 30, this.graphHighY, this.graphLowY - 2, 0x33000000);
            }
            this.vLine(this.graphLeft + (this.graphRight - this.graphLeft) * i / 30, this.graphLowY - 3, this.graphLowY + (longer ? 5 : 3), -16777216);
        }
    }

    private void updateBoundFromTextfield(int fieldId) {
        try {
            switch (fieldId) {
                case 0: {
                    float prev = this.module.lowerBound;
                    this.module.lowerBound = MathHelper.func_76131_a((float)Float.parseFloat(this.lowerBoundField.func_146179_b()), (float)-1.0f, (float)30.0f);
                    if (!MathHelper.func_180185_a((float)this.module.lowerBound, (float)prev)) {
                        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
                    }
                    break;
                }
                case 1: {
                    float prev = this.module.higherBound;
                    this.module.higherBound = MathHelper.func_76131_a((float)Float.parseFloat(this.higherBoundField.func_146179_b()), (float)-1.0f, (float)30.0f);
                    if (!MathHelper.func_180185_a((float)this.module.higherBound, (float)prev)) {
                        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown field id " + fieldId);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.lowerBoundArea.func_199315_b((int)mouseX, (int)mouseY)) {
            this.module.lowerBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.lowerBound = Math.min(Math.max(-1.0f, this.module.lowerBound), 30.0f);
            this.grabLower = true;
            return true;
        }
        if (this.higherBoundArea.func_199315_b((int)mouseX, (int)mouseY)) {
            this.module.higherBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.higherBound = Math.min(Math.max(-1.0f, this.module.higherBound), 30.0f);
            this.grabHigher = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        if (this.grabLower) {
            this.module.lowerBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.lowerBound = Math.min(Math.max(-1.0f, this.module.lowerBound), 30.0f);
            return true;
        }
        if (this.grabHigher) {
            this.module.higherBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.higherBound = Math.min(Math.max(-1.0f, this.module.higherBound), 30.0f);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (this.grabLower) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
            this.grabLower = false;
            return true;
        }
        if (this.grabHigher) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
            this.grabHigher = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.module.advancedConfig) {
            this.minecraft.func_147108_a((Screen)new GuiPressureModuleSimple(this.module));
        }
        if (!this.lowerBoundField.isFocused()) {
            this.lowerBoundField.func_146180_a(PneumaticCraftUtils.roundNumberTo(this.module.lowerBound, 1));
        }
        if (!this.higherBoundField.isFocused()) {
            this.higherBoundField.func_146180_a(PneumaticCraftUtils.roundNumberTo(this.module.higherBound, 1));
        }
    }
}

