/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import me.desht.pneumaticcraft.client.gui.tubemodule.GuiPressureModule;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiTubeModule;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneReceiving;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class GuiPressureModuleSimple
extends GuiTubeModule<TubeModule> {
    private WidgetTextFieldNumber thresholdField;
    private WidgetButtonExtended moreOrLessButton;

    GuiPressureModuleSimple(BlockPos pos) {
        super(pos);
        this.ySize = 57;
    }

    GuiPressureModuleSimple(TubeModule module) {
        super(module);
        this.ySize = 57;
    }

    @Override
    public void init() {
        super.init();
        String titleText = this.title.func_150254_d();
        this.addLabel(titleText, this.width / 2 - this.font.func_78256_a(titleText) / 2, this.guiTop + 5);
        WidgetCheckBox advancedMode = new WidgetCheckBox(this.guiLeft + 6, this.guiTop + 20, -12566464, "pneumaticcraft.gui.tubeModule.advancedConfig", b -> {
            this.module.advancedConfig = true;
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
        }).setTooltip(I18n.func_135052_a((String)"pneumaticcraft.gui.tubeModule.advancedConfig.tooltip", (Object[])new Object[0]));
        advancedMode.checked = false;
        this.addButton(advancedMode);
        this.font.getClass();
        this.thresholdField = new WidgetTextFieldNumber(this.font, this.guiLeft + 105, this.guiTop + 35, 30, 9 + 2).setDecimals(1);
        this.addButton((Widget)this.thresholdField);
        this.setFocused((IGuiEventListener)this.thresholdField);
        this.thresholdField.func_146195_b(true);
        if (this.module instanceof TubeModuleRedstoneReceiving) {
            this.thresholdField.setValue(((TubeModuleRedstoneReceiving)this.module).getThreshold());
            String s = I18n.func_135052_a((String)"pneumaticcraft.gui.tubeModule.simpleConfig.threshold", (Object[])new Object[0]);
            this.addLabel(s, this.guiLeft + 80 - this.font.func_78256_a(s), this.guiTop + 36);
        } else {
            this.thresholdField.setValue(this.module.lowerBound);
            String s = I18n.func_135052_a((String)"pneumaticcraft.gui.tubeModule.simpleConfig.turn", (Object[])new Object[0]);
            this.addLabel(s, this.guiLeft + 80 - this.font.func_78256_a(s), this.guiTop + 36);
            this.moreOrLessButton = new WidgetButtonExtended(this.guiLeft + 85, this.guiTop + 33, 16, 16, this.module.lowerBound < this.module.higherBound ? ">" : "<", b -> this.flipThreshold());
            this.moreOrLessButton.setTooltipText(I18n.func_135052_a((String)(this.module.lowerBound < this.module.higherBound ? "pneumaticcraft.gui.tubeModule.simpleConfig.higherThan" : "pneumaticcraft.gui.tubeModule.simpleConfig.lowerThan"), (Object[])new Object[0]));
            this.addButton((Widget)this.moreOrLessButton);
        }
        this.addLabel(I18n.func_135052_a((String)"pneumaticcraft.gui.general.bar", (Object[])new Object[0]), this.guiLeft + 137, this.guiTop + 37);
    }

    private void flipThreshold() {
        float temp = this.module.higherBound;
        this.module.higherBound = this.module.lowerBound;
        this.module.lowerBound = temp;
        this.updateThreshold();
        this.moreOrLessButton.setMessage(this.module.lowerBound < this.module.higherBound ? ">" : "<");
        this.moreOrLessButton.setTooltipText(I18n.func_135052_a((String)(this.module.lowerBound < this.module.higherBound ? "pneumaticcraft.gui.tubeModule.simpleConfig.higherThan" : "pneumaticcraft.gui.tubeModule.simpleConfig.lowerThan"), (Object[])new Object[0]));
        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.module.advancedConfig) {
            this.module.lowerBound = (float)this.thresholdField.getDoubleValue();
            this.minecraft.func_147108_a((Screen)new GuiPressureModule(this.module));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MODULE_SIMPLE;
    }

    private void updateThreshold() {
        boolean moreThanMode = this.module.lowerBound > this.module.higherBound;
        this.module.lowerBound = (float)this.thresholdField.getDoubleValue();
        this.module.higherBound = moreThanMode ? this.module.lowerBound - 0.1f : this.module.lowerBound + 0.1f;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.thresholdField.isFocused()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.updateThreshold();
        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
        super.onClose();
    }
}

